// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package com.lark.oapi.service.sheets;

import com.lark.oapi.core.Config;
import com.lark.oapi.event.IEventHandler;
import com.lark.oapi.service.sheets.v3.V3;
import com.lark.oapi.service.sheets.v3.model.*;
import com.lark.oapi.service.sheets.v3.resource.Spreadsheet;
import com.lark.oapi.service.sheets.v3.resource.SpreadsheetSheet;
import com.lark.oapi.service.sheets.v3.resource.SpreadsheetSheetFilter;
import com.lark.oapi.service.sheets.v3.resource.SpreadsheetSheetFilterView;
import com.lark.oapi.service.sheets.v3.resource.SpreadsheetSheetFilterViewCondition;
import com.lark.oapi.service.sheets.v3.resource.SpreadsheetSheetFloatImage;

public class SheetsService {
    private final V3 v3;
    private final Spreadsheet spreadsheet; // 表格
    private final SpreadsheetSheet spreadsheetSheet; // 工作表
    private final SpreadsheetSheetFilter spreadsheetSheetFilter; // 筛选
    private final SpreadsheetSheetFilterView spreadsheetSheetFilterView; // 筛选视图
    private final SpreadsheetSheetFilterViewCondition spreadsheetSheetFilterViewCondition; // 筛选条件
    private final SpreadsheetSheetFloatImage spreadsheetSheetFloatImage; // 浮动图片

    public SheetsService(Config config) {
        this.v3 = new V3(config);
        this.spreadsheet = new Spreadsheet(config);
        this.spreadsheetSheet = new SpreadsheetSheet(config);
        this.spreadsheetSheetFilter = new SpreadsheetSheetFilter(config);
        this.spreadsheetSheetFilterView = new SpreadsheetSheetFilterView(config);
        this.spreadsheetSheetFilterViewCondition = new SpreadsheetSheetFilterViewCondition(config);
        this.spreadsheetSheetFloatImage = new SpreadsheetSheetFloatImage(config);
    }

    public V3 v3() {
        return v3;
    }

    public Spreadsheet spreadsheet() {
        return spreadsheet;
    }

    public SpreadsheetSheet spreadsheetSheet() {
        return spreadsheetSheet;
    }

    public SpreadsheetSheetFilter spreadsheetSheetFilter() {
        return spreadsheetSheetFilter;
    }

    public SpreadsheetSheetFilterView spreadsheetSheetFilterView() {
        return spreadsheetSheetFilterView;
    }

    public SpreadsheetSheetFilterViewCondition spreadsheetSheetFilterViewCondition() {
        return spreadsheetSheetFilterViewCondition;
    }

    public SpreadsheetSheetFloatImage spreadsheetSheetFloatImage() {
        return spreadsheetSheetFloatImage;
    }
}