// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.sheets.v3.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.sheets.v3.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class BorderStyle {
    /**
     * 上边框样式
     * <p> 示例值：
     */
    @SerializedName("top")
    private TopBorderStyle top;
    /**
     * 左边框样式
     * <p> 示例值：
     */
    @SerializedName("left")
    private LeftBorderStyle left;
    /**
     * 右边框样式
     * <p> 示例值：
     */
    @SerializedName("right")
    private RightBorderStyle right;
    /**
     * 下边框样式
     * <p> 示例值：
     */
    @SerializedName("bottom")
    private BottomBorderStyle bottom;

    // builder 开始
    public BorderStyle() {
    }

    public BorderStyle(Builder builder) {
        /**
         * 上边框样式
         * <p> 示例值：
         */
        this.top = builder.top;
        /**
         * 左边框样式
         * <p> 示例值：
         */
        this.left = builder.left;
        /**
         * 右边框样式
         * <p> 示例值：
         */
        this.right = builder.right;
        /**
         * 下边框样式
         * <p> 示例值：
         */
        this.bottom = builder.bottom;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public TopBorderStyle getTop() {
        return this.top;
    }

    public void setTop(TopBorderStyle top) {
        this.top = top;
    }

    public LeftBorderStyle getLeft() {
        return this.left;
    }

    public void setLeft(LeftBorderStyle left) {
        this.left = left;
    }

    public RightBorderStyle getRight() {
        return this.right;
    }

    public void setRight(RightBorderStyle right) {
        this.right = right;
    }

    public BottomBorderStyle getBottom() {
        return this.bottom;
    }

    public void setBottom(BottomBorderStyle bottom) {
        this.bottom = bottom;
    }

    public static class Builder {
        /**
         * 上边框样式
         * <p> 示例值：
         */
        private TopBorderStyle top;
        /**
         * 左边框样式
         * <p> 示例值：
         */
        private LeftBorderStyle left;
        /**
         * 右边框样式
         * <p> 示例值：
         */
        private RightBorderStyle right;
        /**
         * 下边框样式
         * <p> 示例值：
         */
        private BottomBorderStyle bottom;

        /**
         * 上边框样式
         * <p> 示例值：
         *
         * @param top
         * @return
         */
        public Builder top(TopBorderStyle top) {
            this.top = top;
            return this;
        }


        /**
         * 左边框样式
         * <p> 示例值：
         *
         * @param left
         * @return
         */
        public Builder left(LeftBorderStyle left) {
            this.left = left;
            return this;
        }


        /**
         * 右边框样式
         * <p> 示例值：
         *
         * @param right
         * @return
         */
        public Builder right(RightBorderStyle right) {
            this.right = right;
            return this;
        }


        /**
         * 下边框样式
         * <p> 示例值：
         *
         * @param bottom
         * @return
         */
        public Builder bottom(BottomBorderStyle bottom) {
            this.bottom = bottom;
            return this;
        }


        public BorderStyle build() {
            return new BorderStyle(this);
        }
    }
}
