/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.mybatis;

import com.mybatisflex.annotation.UseDataSource;
import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.datasource.DataSourceKey;
import com.mybatisflex.core.datasource.FlexDataSource;
import com.mybatisflex.core.dialect.DbType;
import com.mybatisflex.core.dialect.DialectFactory;
import com.mybatisflex.core.row.RowMapper;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.sql.DataSource;
import org.apache.ibatis.reflection.ExceptionUtil;

public class MapperInvocationHandler
implements InvocationHandler {
    private final Object mapper;
    private final FlexDataSource dataSource;

    public MapperInvocationHandler(Object mapper, DataSource dataSource) {
        this.mapper = mapper;
        this.dataSource = dataSource instanceof FlexDataSource ? (FlexDataSource)dataSource : null;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean needClearDsKey = false;
        boolean needClearDbType = false;
        try {
            DbType dbType;
            String shardingDataSourceKey;
            String configDataSourceKey;
            String dataSourceKey = DataSourceKey.get();
            if (StringUtil.isBlank(dataSourceKey) && StringUtil.isNotBlank(configDataSourceKey = MapperInvocationHandler.getConfigDataSourceKey(method, proxy))) {
                dataSourceKey = configDataSourceKey;
                DataSourceKey.use(dataSourceKey);
                needClearDsKey = true;
            }
            if ((shardingDataSourceKey = DataSourceKey.getByShardingStrategy(dataSourceKey, proxy, method, args)) != null && !shardingDataSourceKey.equals(dataSourceKey)) {
                DataSourceKey.use(shardingDataSourceKey);
                needClearDsKey = true;
            }
            if ((dbType = DialectFactory.getHintDbType()) == null) {
                if (shardingDataSourceKey != null && this.dataSource != null) {
                    dbType = this.dataSource.getDbType(shardingDataSourceKey);
                }
                if (dbType == null && dataSourceKey != null && this.dataSource != null) {
                    dbType = this.dataSource.getDbType(dataSourceKey);
                }
                if (dbType == null) {
                    dbType = DialectFactory.getGlobalDbType();
                }
                if (dbType == null) {
                    dbType = FlexGlobalConfig.getDefaultConfig().getDbType();
                }
                DialectFactory.setHintDbType(dbType);
                needClearDbType = true;
            }
            Object object = method.invoke(this.mapper, args);
            return object;
        }
        catch (Throwable e) {
            throw ExceptionUtil.unwrapThrowable((Throwable)e);
        }
        finally {
            if (needClearDbType) {
                DialectFactory.clearHintDbType();
            }
            if (needClearDsKey) {
                DataSourceKey.clear();
            }
        }
    }

    private static String getConfigDataSourceKey(Method method, Object proxy) {
        String dataSourceKey;
        TableInfo tableInfo;
        Class<?>[] interfaces;
        UseDataSource useDataSource = method.getAnnotation(UseDataSource.class);
        if (useDataSource != null && StringUtil.isNotBlank(useDataSource.value())) {
            return useDataSource.value();
        }
        for (Class<?> anInterface : interfaces = proxy.getClass().getInterfaces()) {
            UseDataSource annotation = anInterface.getAnnotation(UseDataSource.class);
            if (annotation == null) continue;
            return annotation.value();
        }
        if (interfaces[0] != RowMapper.class && (tableInfo = TableInfoFactory.ofMapperClass(interfaces[0])) != null && StringUtil.isNotBlank(dataSourceKey = tableInfo.getDataSource())) {
            return dataSourceKey;
        }
        return null;
    }
}

