/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class ArrayTypeStyleCheck
extends Check {
    private boolean javaStyle = true;

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{17};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST typeAST = ast.getParent();
        if (typeAST.getType() != 13) {
            return;
        }
        DetailAST parentAst = typeAST.getParent();
        if (parentAst.getType() == 9) {
            return;
        }
        DetailAST variableAST = typeAST.getNextSibling();
        if (variableAST != null) {
            boolean isJavaStyle;
            boolean bl = isJavaStyle = variableAST.getLineNo() > ast.getLineNo() || variableAST.getColumnNo() > ast.getColumnNo();
            if (isJavaStyle != this.javaStyle) {
                this.log(ast.getLineNo(), ast.getColumnNo(), "array.type.style", new Object[0]);
            }
        }
    }

    public void setJavaStyle(boolean javaStyle) {
        this.javaStyle = javaStyle;
    }
}

