/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.header;

import com.puppycrawl.tools.checkstyle.checks.header.AbstractHeaderCheck;
import java.io.File;
import java.util.Arrays;
import java.util.List;

public class HeaderCheck
extends AbstractHeaderCheck {
    public static final String MSG_MISSING = "header.missing";
    public static final String MSG_MISMATCH = "header.mismatch";
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private int[] ignoreLines = EMPTY_INT_ARRAY;

    private boolean isIgnoreLine(int lineNo) {
        return Arrays.binarySearch(this.ignoreLines, lineNo) >= 0;
    }

    protected boolean isMatch(int lineNumber, String line) {
        return this.isIgnoreLine(lineNumber + 1) || ((String)this.getHeaderLines().get(lineNumber)).equals(line);
    }

    public void setIgnoreLines(int ... list) {
        if (list.length == 0) {
            this.ignoreLines = EMPTY_INT_ARRAY;
            return;
        }
        this.ignoreLines = new int[list.length];
        System.arraycopy(list, 0, this.ignoreLines, 0, list.length);
        Arrays.sort(this.ignoreLines);
    }

    @Override
    protected void processFiltered(File file, List<String> lines) {
        if (this.getHeaderLines().size() > lines.size()) {
            this.log(1, MSG_MISSING, new Object[0]);
        } else {
            for (int i = 0; i < this.getHeaderLines().size(); ++i) {
                if (this.isMatch(i, lines.get(i))) continue;
                this.log(i + 1, MSG_MISMATCH, this.getHeaderLines().get(i));
                break;
            }
        }
    }
}

