/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.header;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.checks.header.AbstractHeaderCheck;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.lang3.StringUtils;

public class RegexpHeaderCheck
extends AbstractHeaderCheck {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final String MSG_HEADER_MISSING = "header.missing";
    private static final String MSG_HEADER_MISMATCH = "header.mismatch";
    private final List<Pattern> headerRegexps = Lists.newArrayList();
    private int[] multiLines = EMPTY_INT_ARRAY;

    public void setMultiLines(int ... list) {
        if (list.length == 0) {
            this.multiLines = EMPTY_INT_ARRAY;
            return;
        }
        this.multiLines = new int[list.length];
        System.arraycopy(list, 0, this.multiLines, 0, list.length);
        Arrays.sort(this.multiLines);
    }

    @Override
    protected void processFiltered(File file, List<String> lines) {
        int fileSize;
        int headerSize = this.getHeaderLines().size();
        if (headerSize - this.multiLines.length > (fileSize = lines.size())) {
            this.log(1, MSG_HEADER_MISSING, new Object[0]);
        } else {
            int i;
            int headerLineNo = 0;
            for (i = 0; headerLineNo < headerSize && i < fileSize; ++i) {
                String line = lines.get(i);
                boolean isMatch = this.isMatch(line, headerLineNo);
                while (!isMatch && this.isMultiLine(headerLineNo)) {
                    isMatch = ++headerLineNo == headerSize || this.isMatch(line, headerLineNo);
                }
                if (!isMatch) {
                    this.log(i + 1, MSG_HEADER_MISMATCH, this.getHeaderLines().get(headerLineNo));
                    break;
                }
                if (this.isMultiLine(headerLineNo)) continue;
                ++headerLineNo;
            }
            if (i == fileSize) {
                this.logFirstSinglelineLine(headerLineNo, headerSize);
            }
        }
    }

    private void logFirstSinglelineLine(int startHeaderLine, int headerSize) {
        for (int lineNum = startHeaderLine; lineNum < headerSize; ++lineNum) {
            if (this.isMultiLine(lineNum)) continue;
            this.log(1, MSG_HEADER_MISSING, new Object[0]);
            break;
        }
    }

    private boolean isMatch(String line, int headerLineNo) {
        return this.headerRegexps.get(headerLineNo).matcher(line).find();
    }

    private boolean isMultiLine(int lineNo) {
        return Arrays.binarySearch(this.multiLines, lineNo + 1) >= 0;
    }

    @Override
    protected void postProcessHeaderLines() {
        ImmutableList<String> headerLines = this.getHeaderLines();
        this.headerRegexps.clear();
        for (String line : headerLines) {
            try {
                this.headerRegexps.add(Pattern.compile(line));
            }
            catch (PatternSyntaxException ignored) {
                throw new ConversionException("line " + (this.headerRegexps.size() + 1) + " in header specification" + " is not a regular expression");
            }
        }
    }

    @Override
    public void setHeader(String header) {
        if (StringUtils.isBlank((CharSequence)header)) {
            return;
        }
        if (!CommonUtils.isPatternValid(header)) {
            throw new ConversionException("Unable to parse format: " + header);
        }
        super.setHeader(header);
    }
}

