/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import org.apache.commons.lang3.ArrayUtils;

public class WhitespaceAroundCheck
extends Check {
    public static final String WS_NOT_PRECEDED = "ws.notPreceded";
    public static final String WS_NOT_FOLLOWED = "ws.notFollowed";
    private boolean allowEmptyConstructors;
    private boolean allowEmptyMethods;
    private boolean allowEmptyTypes;
    private boolean allowEmptyLoops;
    private boolean ignoreEnhancedForColon = true;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{80, 114, 106, 112, 108, 124, 104, 113, 107, 82, 127, 101, 175, 116, 120, 118, 111, 72, 119, 96, 85, 92, 97, 91, 83, 88, 89, 67, 95, 84, 110, 117, 126, 99, 128, 102, 115, 125, 98, 109, 73, 122, 7, 105, 123, 103, 60, 100, 151, 174};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{80, 114, 106, 112, 108, 124, 104, 113, 107, 82, 127, 101, 175, 116, 120, 118, 111, 72, 119, 96, 85, 92, 97, 91, 83, 88, 89, 67, 95, 84, 110, 117, 126, 99, 128, 102, 115, 125, 98, 109, 73, 122, 7, 105, 123, 103, 60, 100, 151, 174, 167, 172, 173};
    }

    @Override
    public int[] getRequiredTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    public void setAllowEmptyMethods(boolean allow) {
        this.allowEmptyMethods = allow;
    }

    public void setAllowEmptyConstructors(boolean allow) {
        this.allowEmptyConstructors = allow;
    }

    public void setIgnoreEnhancedForColon(boolean ignore) {
        this.ignoreEnhancedForColon = ignore;
    }

    public void setAllowEmptyTypes(boolean allow) {
        this.allowEmptyTypes = allow;
    }

    public void setAllowEmptyLoops(boolean allow) {
        this.allowEmptyLoops = allow;
    }

    @Override
    public void visitToken(DetailAST ast) {
        int currentType = ast.getType();
        if (this.isNotRelevantSituation(ast, currentType)) {
            return;
        }
        String line = this.getLine(ast.getLineNo() - 1);
        int before = ast.getColumnNo() - 1;
        int after = ast.getColumnNo() + ast.getText().length();
        if (before >= 0 && !Character.isWhitespace(line.charAt(before))) {
            this.log(ast.getLineNo(), ast.getColumnNo(), WS_NOT_PRECEDED, ast.getText());
        }
        if (after >= line.length()) {
            return;
        }
        char nextChar = line.charAt(after);
        if (!(Character.isWhitespace(nextChar) || currentType == 88 && ast.getFirstChild().getType() == 45 || WhitespaceAroundCheck.isAnonymousInnerClassEnd(currentType, nextChar))) {
            this.log(ast.getLineNo(), ast.getColumnNo() + ast.getText().length(), WS_NOT_FOLLOWED, ast.getText());
        }
    }

    private static boolean isAnonymousInnerClassEnd(int currentType, char nextChar) {
        return currentType == 73 && (nextChar == ')' || nextChar == ';' || nextChar == ',' || nextChar == '.');
    }

    private boolean isNotRelevantSituation(DetailAST ast, int currentType) {
        int parentType = ast.getParent().getType();
        boolean starImport = currentType == 60 && parentType == 59;
        boolean slistInsideCaseGroup = currentType == 7 && parentType == 33;
        boolean starImportOrSlistInsideCaseGroup = starImport || slistInsideCaseGroup;
        boolean colonOfCaseOrDefaultOrForEach = WhitespaceAroundCheck.isColonOfCaseOrDefault(currentType, parentType) || this.isColonOfForEach(currentType, parentType);
        boolean emptyBlockOrType = this.isEmptyBlock(ast, parentType) || this.allowEmptyTypes && WhitespaceAroundCheck.isEmptyType(ast, parentType);
        return starImportOrSlistInsideCaseGroup || colonOfCaseOrDefaultOrForEach || emptyBlockOrType || WhitespaceAroundCheck.isArrayInitialization(currentType, parentType);
    }

    private boolean isEmptyBlock(DetailAST ast, int parentType) {
        return this.isEmptyMethodBlock(ast, parentType) || this.isEmptyCtorBlock(ast, parentType) || this.isEmptyLoop(ast, parentType);
    }

    private static boolean isEmptyBlock(DetailAST ast, int parentType, int match) {
        int type = ast.getType();
        if (type == 73) {
            DetailAST grandParent = ast.getParent().getParent();
            return parentType == 7 && grandParent.getType() == match;
        }
        return type == 7 && parentType == match && ast.getFirstChild().getType() == 73;
    }

    private static boolean isColonOfCaseOrDefault(int currentType, int parentType) {
        return currentType == 82 && (parentType == 94 || parentType == 93);
    }

    private boolean isColonOfForEach(int currentType, int parentType) {
        return currentType == 82 && parentType == 156 && this.ignoreEnhancedForColon;
    }

    private static boolean isArrayInitialization(int currentType, int parentType) {
        return !(currentType != 73 && currentType != 72 || parentType != 29 && parentType != 162);
    }

    private boolean isEmptyMethodBlock(DetailAST ast, int parentType) {
        return this.allowEmptyMethods && WhitespaceAroundCheck.isEmptyBlock(ast, parentType, 9);
    }

    private boolean isEmptyCtorBlock(DetailAST ast, int parentType) {
        return this.allowEmptyConstructors && WhitespaceAroundCheck.isEmptyBlock(ast, parentType, 8);
    }

    private boolean isEmptyLoop(DetailAST ast, int parentType) {
        return this.allowEmptyLoops && (WhitespaceAroundCheck.isEmptyBlock(ast, parentType, 91) || WhitespaceAroundCheck.isEmptyBlock(ast, parentType, 84) || WhitespaceAroundCheck.isEmptyBlock(ast, parentType, 85));
    }

    private static boolean isEmptyType(DetailAST ast, int parentType) {
        int type = ast.getType();
        return (type == 73 || type == 72) && parentType == 6;
    }
}

