/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import com.puppycrawl.tools.checkstyle.gui.JTreeTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

class ListToTreeSelectionModelWrapper
extends DefaultTreeSelectionModel {
    private static final long serialVersionUID = 2267930983939339510L;
    private boolean updatingListSelectionModel;
    private final JTreeTable treeTable;

    ListToTreeSelectionModelWrapper(JTreeTable jTreeTable) {
        this.treeTable = jTreeTable;
        this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
    }

    final ListSelectionModel getListSelectionModel() {
        return this.listSelectionModel;
    }

    @Override
    public void resetRowSelection() {
        if (!this.updatingListSelectionModel) {
            this.updatingListSelectionModel = true;
            try {
                super.resetRowSelection();
            }
            finally {
                this.updatingListSelectionModel = false;
            }
        }
    }

    private ListSelectionListener createListSelectionListener() {
        return new ListSelectionHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSelectedPathsFromSelectedRows() {
        if (!this.updatingListSelectionModel) {
            this.updatingListSelectionModel = true;
            try {
                int min = this.listSelectionModel.getMinSelectionIndex();
                int max = this.listSelectionModel.getMaxSelectionIndex();
                this.clearSelection();
                if (min != -1 && max != -1) {
                    for (int counter = min; counter <= max; ++counter) {
                        this.updateSelectedPathIfRowIsSelected(counter);
                    }
                }
            }
            finally {
                this.updatingListSelectionModel = false;
            }
        }
    }

    private void updateSelectedPathIfRowIsSelected(int counter) {
        TreePath selPath;
        if (this.listSelectionModel.isSelectedIndex(counter) && (selPath = this.treeTable.getTree().getPathForRow(counter)) != null) {
            this.addSelectionPath(selPath);
        }
    }

    private class ListSelectionHandler
    implements ListSelectionListener {
        private ListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
        }
    }
}

