/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod;

import com.redis.lettucemod.api.StatefulRedisModulesConnection;
import com.redis.lettucemod.api.reactive.RedisModulesReactiveCommands;
import com.redis.lettucemod.bloom.BloomCommandBuilder;
import com.redis.lettucemod.bloom.BloomFilterInfo;
import com.redis.lettucemod.bloom.BloomFilterInfoType;
import com.redis.lettucemod.bloom.BloomFilterInsertOptions;
import com.redis.lettucemod.bloom.BloomFilterReserveOptions;
import com.redis.lettucemod.bloom.CmsInfo;
import com.redis.lettucemod.bloom.CuckooFilter;
import com.redis.lettucemod.bloom.CuckooFilterInsertOptions;
import com.redis.lettucemod.bloom.CuckooFilterReserveOptions;
import com.redis.lettucemod.bloom.LongScoredValue;
import com.redis.lettucemod.bloom.TDigestInfo;
import com.redis.lettucemod.bloom.TDigestMergeOptions;
import com.redis.lettucemod.bloom.TopKInfo;
import com.redis.lettucemod.search.AggregateOptions;
import com.redis.lettucemod.search.AggregateResults;
import com.redis.lettucemod.search.AggregateWithCursorResults;
import com.redis.lettucemod.search.CursorOptions;
import com.redis.lettucemod.search.Field;
import com.redis.lettucemod.search.SearchCommandBuilder;
import com.redis.lettucemod.search.SearchOptions;
import com.redis.lettucemod.search.SearchResults;
import com.redis.lettucemod.search.Suggestion;
import com.redis.lettucemod.search.SuggetOptions;
import com.redis.lettucemod.timeseries.AddOptions;
import com.redis.lettucemod.timeseries.AlterOptions;
import com.redis.lettucemod.timeseries.CreateOptions;
import com.redis.lettucemod.timeseries.CreateRuleOptions;
import com.redis.lettucemod.timeseries.GetResult;
import com.redis.lettucemod.timeseries.IncrbyOptions;
import com.redis.lettucemod.timeseries.KeySample;
import com.redis.lettucemod.timeseries.MGetOptions;
import com.redis.lettucemod.timeseries.MRangeOptions;
import com.redis.lettucemod.timeseries.RangeOptions;
import com.redis.lettucemod.timeseries.RangeResult;
import com.redis.lettucemod.timeseries.Sample;
import com.redis.lettucemod.timeseries.TimeRange;
import com.redis.lettucemod.timeseries.TimeSeriesCommandBuilder;
import io.lettuce.core.KeyValue;
import io.lettuce.core.RedisReactiveCommandsImpl;
import io.lettuce.core.Value;
import io.lettuce.core.codec.RedisCodec;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedisModulesReactiveCommandsImpl<K, V>
extends RedisReactiveCommandsImpl<K, V>
implements RedisModulesReactiveCommands<K, V> {
    private final StatefulRedisModulesConnection<K, V> connection;
    private final TimeSeriesCommandBuilder<K, V> timeSeriesCommandBuilder;
    private final SearchCommandBuilder<K, V> searchCommandBuilder;
    private final BloomCommandBuilder<K, V> bloomCommandBuilder;

    public RedisModulesReactiveCommandsImpl(StatefulRedisModulesConnection<K, V> connection, RedisCodec<K, V> codec) {
        super(connection, codec);
        this.connection = connection;
        this.timeSeriesCommandBuilder = new TimeSeriesCommandBuilder<K, V>(codec);
        this.searchCommandBuilder = new SearchCommandBuilder<K, V>(codec);
        this.bloomCommandBuilder = new BloomCommandBuilder<K, V>(codec);
    }

    @Override
    public StatefulRedisModulesConnection<K, V> getStatefulConnection() {
        return this.connection;
    }

    @Override
    public Mono<String> tsCreate(K key, CreateOptions<K, V> options) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.create(key, options));
    }

    @Override
    public Mono<String> tsAlter(K key, AlterOptions<K, V> options) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.alter(key, options));
    }

    @Override
    public Mono<Long> tsAdd(K key, Sample sample) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.add(key, sample));
    }

    @Override
    public Mono<Long> tsAdd(K key, Sample sample, AddOptions<K, V> options) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.add(key, sample, options));
    }

    @Override
    public Mono<Long> tsIncrby(K key, double value) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.incrby(key, value, null));
    }

    @Override
    public Mono<Long> tsIncrby(K key, double value, IncrbyOptions<K, V> options) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.incrby(key, value, options));
    }

    @Override
    public Mono<Long> tsDecrby(K key, double value) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.decrby(key, value, null));
    }

    @Override
    public Mono<Long> tsDecrby(K key, double value, IncrbyOptions<K, V> options) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.decrby(key, value, options));
    }

    @Override
    public Flux<Long> tsMadd(KeySample<K> ... samples) {
        return this.createDissolvingFlux(() -> this.timeSeriesCommandBuilder.madd(samples));
    }

    @Override
    public Mono<String> tsCreaterule(K sourceKey, K destKey, CreateRuleOptions options) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.createRule(sourceKey, destKey, options));
    }

    @Override
    public Mono<String> tsDeleterule(K sourceKey, K destKey) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.deleteRule(sourceKey, destKey));
    }

    @Override
    public Flux<Sample> tsRange(K key, TimeRange range) {
        return this.createDissolvingFlux(() -> this.timeSeriesCommandBuilder.range(key, range));
    }

    @Override
    public Flux<Sample> tsRange(K key, TimeRange range, RangeOptions options) {
        return this.createDissolvingFlux(() -> this.timeSeriesCommandBuilder.range(key, range, options));
    }

    @Override
    public Flux<Sample> tsRevrange(K key, TimeRange range) {
        return this.createDissolvingFlux(() -> this.timeSeriesCommandBuilder.revrange(key, range));
    }

    @Override
    public Flux<Sample> tsRevrange(K key, TimeRange range, RangeOptions options) {
        return this.createDissolvingFlux(() -> this.timeSeriesCommandBuilder.revrange(key, range, options));
    }

    @Override
    public Flux<RangeResult<K, V>> tsMrange(TimeRange range) {
        return this.createDissolvingFlux(() -> this.timeSeriesCommandBuilder.mrange(range));
    }

    @Override
    public Flux<RangeResult<K, V>> tsMrange(TimeRange range, MRangeOptions<K, V> options) {
        return this.createDissolvingFlux(() -> this.timeSeriesCommandBuilder.mrange(range, options));
    }

    @Override
    public Flux<RangeResult<K, V>> tsMrevrange(TimeRange range) {
        return this.createDissolvingFlux(() -> this.timeSeriesCommandBuilder.mrevrange(range));
    }

    @Override
    public Flux<RangeResult<K, V>> tsMrevrange(TimeRange range, MRangeOptions<K, V> options) {
        return this.createDissolvingFlux(() -> this.timeSeriesCommandBuilder.mrevrange(range, options));
    }

    @Override
    public Mono<Sample> tsGet(K key) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.get(key));
    }

    @Override
    public Flux<GetResult<K, V>> tsMget(MGetOptions<K, V> options) {
        return this.createDissolvingFlux(() -> this.timeSeriesCommandBuilder.mget(options));
    }

    @Override
    public Flux<GetResult<K, V>> tsMget(V ... filters) {
        return this.createDissolvingFlux(() -> this.timeSeriesCommandBuilder.mget(filters));
    }

    @Override
    public Flux<GetResult<K, V>> tsMgetWithLabels(V ... filters) {
        return this.createDissolvingFlux(() -> this.timeSeriesCommandBuilder.mgetWithLabels(filters));
    }

    @Override
    public Flux<Object> tsInfo(K key) {
        return this.createDissolvingFlux(() -> this.timeSeriesCommandBuilder.info(key, false));
    }

    @Override
    public Flux<Object> tsInfoDebug(K key) {
        return this.createDissolvingFlux(() -> this.timeSeriesCommandBuilder.info(key, true));
    }

    @Override
    public Flux<V> tsQueryIndex(V ... filters) {
        return this.createDissolvingFlux(() -> this.timeSeriesCommandBuilder.queryIndex(filters));
    }

    @Override
    public Mono<Long> tsDel(K key, TimeRange timeRange) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.tsDel(key, timeRange));
    }

    @Override
    public Mono<String> ftCreate(K index, Field<K> ... fields) {
        return this.ftCreate(index, (com.redis.lettucemod.search.CreateOptions<K, V>)null, fields);
    }

    @Override
    public Mono<String> ftCreate(K index, com.redis.lettucemod.search.CreateOptions<K, V> options, Field<K> ... fields) {
        return this.createMono(() -> this.searchCommandBuilder.create(index, options, fields));
    }

    @Override
    public Mono<String> ftDropindex(K index) {
        return this.createMono(() -> this.searchCommandBuilder.dropIndex(index, false));
    }

    @Override
    public Mono<String> ftDropindexDeleteDocs(K index) {
        return this.createMono(() -> this.searchCommandBuilder.dropIndex(index, true));
    }

    @Override
    public Flux<Object> ftInfo(K index) {
        return this.createDissolvingFlux(() -> this.searchCommandBuilder.info(index));
    }

    @Override
    public Mono<SearchResults<K, V>> ftSearch(K index, V query) {
        return this.createMono(() -> this.searchCommandBuilder.search(index, query, null));
    }

    @Override
    public Mono<SearchResults<K, V>> ftSearch(K index, V query, SearchOptions<K, V> options) {
        return this.createMono(() -> this.searchCommandBuilder.search(index, query, options));
    }

    @Override
    public Mono<AggregateResults<K>> ftAggregate(K index, V query) {
        return this.createMono(() -> this.searchCommandBuilder.aggregate(index, query, null));
    }

    @Override
    public Mono<AggregateResults<K>> ftAggregate(K index, V query, AggregateOptions<K, V> options) {
        return this.createMono(() -> this.searchCommandBuilder.aggregate(index, query, options));
    }

    @Override
    public Mono<AggregateWithCursorResults<K>> ftAggregate(K index, V query, CursorOptions cursor) {
        return this.createMono(() -> this.searchCommandBuilder.aggregate(index, query, cursor, null));
    }

    @Override
    public Mono<AggregateWithCursorResults<K>> ftAggregate(K index, V query, CursorOptions cursor, AggregateOptions<K, V> options) {
        return this.createMono(() -> this.searchCommandBuilder.aggregate(index, query, cursor, options));
    }

    @Override
    public Mono<AggregateWithCursorResults<K>> ftCursorRead(K index, long cursor) {
        return this.createMono(() -> this.searchCommandBuilder.cursorRead(index, cursor, null));
    }

    @Override
    public Mono<AggregateWithCursorResults<K>> ftCursorRead(K index, long cursor, long count) {
        return this.createMono(() -> this.searchCommandBuilder.cursorRead(index, cursor, count));
    }

    @Override
    public Mono<String> ftCursorDelete(K index, long cursor) {
        return this.createMono(() -> this.searchCommandBuilder.cursorDelete(index, cursor));
    }

    @Override
    public Mono<Long> ftSugadd(K key, Suggestion<V> suggestion) {
        return this.createMono(() -> this.searchCommandBuilder.sugadd(key, suggestion));
    }

    @Override
    public Mono<Long> ftSugaddIncr(K key, Suggestion<V> suggestion) {
        return this.createMono(() -> this.searchCommandBuilder.sugaddIncr(key, suggestion));
    }

    @Override
    public Flux<Suggestion<V>> ftSugget(K key, V prefix) {
        return this.createDissolvingFlux(() -> this.searchCommandBuilder.sugget(key, prefix));
    }

    @Override
    public Flux<Suggestion<V>> ftSugget(K key, V prefix, SuggetOptions options) {
        return this.createDissolvingFlux(() -> this.searchCommandBuilder.sugget(key, prefix, options));
    }

    @Override
    public Mono<Boolean> ftSugdel(K key, V string) {
        return this.createMono(() -> this.searchCommandBuilder.sugdel(key, string));
    }

    @Override
    public Mono<Long> ftSuglen(K key) {
        return this.createMono(() -> this.searchCommandBuilder.suglen(key));
    }

    @Override
    public Mono<String> ftAlter(K index, Field<K> field) {
        return this.createMono(() -> this.searchCommandBuilder.alter(index, field));
    }

    @Override
    public Mono<String> ftAliasadd(K name, K index) {
        return this.createMono(() -> this.searchCommandBuilder.aliasAdd(name, index));
    }

    @Override
    public Mono<String> ftAliasupdate(K name, K index) {
        return this.createMono(() -> this.searchCommandBuilder.aliasUpdate(name, index));
    }

    @Override
    public Mono<String> ftAliasdel(K name) {
        return this.createMono(() -> this.searchCommandBuilder.aliasDel(name));
    }

    @Override
    public Flux<K> ftList() {
        return this.createDissolvingFlux(this.searchCommandBuilder::list);
    }

    @Override
    public Flux<V> ftTagvals(K index, K field) {
        return this.createDissolvingFlux(() -> this.searchCommandBuilder.tagVals(index, field));
    }

    @Override
    public Mono<Long> ftDictadd(K dict, V ... terms) {
        return this.createMono(() -> this.searchCommandBuilder.dictadd(dict, terms));
    }

    @Override
    public Mono<Long> ftDictdel(K dict, V ... terms) {
        return this.createMono(() -> this.searchCommandBuilder.dictdel(dict, terms));
    }

    @Override
    public Flux<V> ftDictdump(K dict) {
        return this.createDissolvingFlux(() -> this.searchCommandBuilder.dictdump(dict));
    }

    @Override
    public Flux<Value<V>> topKAdd(K key, V ... items) {
        return this.createDissolvingFlux(() -> this.bloomCommandBuilder.topKAdd(key, items));
    }

    @Override
    public Flux<Value<V>> topKIncrBy(K key, LongScoredValue<V> ... itemIncrements) {
        return this.createDissolvingFlux(() -> this.bloomCommandBuilder.topKIncrBy(key, itemIncrements));
    }

    @Override
    public Mono<TopKInfo> topKInfo(K key) {
        return this.createMono(() -> this.bloomCommandBuilder.topKInfo(key));
    }

    @Override
    public Flux<String> topKList(K key) {
        return this.createDissolvingFlux(() -> this.bloomCommandBuilder.topKList(key));
    }

    @Override
    public Flux<KeyValue<String, Long>> topKListWithScores(K key) {
        return this.createDissolvingFlux(() -> this.bloomCommandBuilder.topKListWithScores(key));
    }

    @Override
    public Flux<Boolean> topKQuery(K key, V ... items) {
        return this.createDissolvingFlux(() -> this.bloomCommandBuilder.topKQuery(key, items));
    }

    @Override
    public Mono<String> topKReserve(K key, long k) {
        return this.createMono(() -> this.bloomCommandBuilder.topKReserve(key, k));
    }

    @Override
    public Mono<String> topKReserve(K key, long k, long width, long depth, double decay) {
        return this.createMono(() -> this.bloomCommandBuilder.topKReserve(key, k, width, depth, decay));
    }

    @Override
    public Mono<String> tDigestAdd(K key, double ... values) {
        return this.createMono(() -> this.bloomCommandBuilder.tDigestAdd(key, values));
    }

    @Override
    public Flux<Double> tDigestByRank(K key, long ... ranks) {
        return this.createDissolvingFlux(() -> this.bloomCommandBuilder.tDigestByRank(key, ranks));
    }

    @Override
    public Flux<Double> tDigestByRevRank(K key, long ... revRanks) {
        return this.createDissolvingFlux(() -> this.bloomCommandBuilder.tDigestByRevRank(key, revRanks));
    }

    @Override
    public Flux<Double> tDigestCdf(K key, double ... values) {
        return this.createDissolvingFlux(() -> this.bloomCommandBuilder.tDigestCdf(key, values));
    }

    @Override
    public Mono<String> tDigestCreate(K key) {
        return this.createMono(() -> this.bloomCommandBuilder.tDigestCreate(key));
    }

    @Override
    public Mono<String> tDigestCreate(K key, long compression) {
        return this.createMono(() -> this.bloomCommandBuilder.tDigestCreate(key, compression));
    }

    @Override
    public Mono<TDigestInfo> tDigestInfo(K key) {
        return this.createMono(() -> this.bloomCommandBuilder.tDigestInfo(key));
    }

    @Override
    public Mono<Double> tDigestMax(K key) {
        return this.createMono(() -> this.bloomCommandBuilder.tDigestMax(key));
    }

    @Override
    public Mono<String> tDigestMerge(K destinationKey, K ... sourceKeys) {
        return this.createMono(() -> this.bloomCommandBuilder.tDigestMerge(destinationKey, sourceKeys));
    }

    @Override
    public Mono<String> tDigestMerge(K destinationKey, TDigestMergeOptions options, K ... sourceKeys) {
        return this.createMono(() -> this.bloomCommandBuilder.tDigestMerge(destinationKey, options, sourceKeys));
    }

    @Override
    public Mono<Double> tDigestMin(K key) {
        return this.createMono(() -> this.bloomCommandBuilder.tDigestMin(key));
    }

    @Override
    public Flux<Double> tDigestQuantile(K key, double ... quantiles) {
        return this.createDissolvingFlux(() -> this.bloomCommandBuilder.tDigestQuantile(key, quantiles));
    }

    @Override
    public Flux<Long> tDigestRank(K key, double ... values) {
        return this.createDissolvingFlux(() -> this.bloomCommandBuilder.tDigestRank(key, values));
    }

    @Override
    public Mono<String> tDigestReset(K key) {
        return this.createMono(() -> this.bloomCommandBuilder.tDigestReset(key));
    }

    @Override
    public Flux<Long> tDigestRevRank(K key, double ... values) {
        return this.createDissolvingFlux(() -> this.bloomCommandBuilder.tDigestRevRank(key, values));
    }

    @Override
    public Mono<Double> tDigestTrimmedMean(K key, double lowCutQuantile, double highCutQuantile) {
        return this.createMono(() -> this.bloomCommandBuilder.tDigestTrimmedMean(key, lowCutQuantile, highCutQuantile));
    }

    @Override
    public Mono<Boolean> bfAdd(K key, V item) {
        return this.createMono(() -> this.bloomCommandBuilder.bfAdd(key, item));
    }

    @Override
    public Mono<Long> bfCard(K key) {
        return this.createMono(() -> this.bloomCommandBuilder.bfCard(key));
    }

    @Override
    public Mono<Boolean> bfExists(K key, V item) {
        return this.createMono(() -> this.bloomCommandBuilder.bfExists(key, item));
    }

    @Override
    public Mono<BloomFilterInfo> bfInfo(K key) {
        return this.createMono(() -> this.bloomCommandBuilder.bfInfo(key));
    }

    @Override
    public Mono<Long> bfInfo(K key, BloomFilterInfoType infoType) {
        return this.createMono(() -> this.bloomCommandBuilder.bfInfo(key, infoType));
    }

    @Override
    public Flux<Boolean> bfInsert(K key, V ... items) {
        return this.createDissolvingFlux(() -> this.bloomCommandBuilder.bfInsert(key, items));
    }

    @Override
    public Flux<Boolean> bfInsert(K key, BloomFilterInsertOptions options, V ... items) {
        return this.createDissolvingFlux(() -> this.bloomCommandBuilder.bfInsert(key, options, items));
    }

    @Override
    public Flux<Boolean> bfMAdd(K key, V ... items) {
        return this.createDissolvingFlux(() -> this.bloomCommandBuilder.bfMAdd(key, items));
    }

    @Override
    public Flux<Boolean> bfMExists(K key, V ... items) {
        return this.createDissolvingFlux(() -> this.bloomCommandBuilder.bfMExists(key, items));
    }

    @Override
    public Mono<String> bfReserve(K key, double errorRate, long capacity) {
        return this.bfReserve(key, errorRate, capacity, null);
    }

    @Override
    public Mono<String> bfReserve(K key, double errorRate, long capacity, BloomFilterReserveOptions options) {
        return this.createMono(() -> this.bloomCommandBuilder.bfReserve(key, errorRate, capacity, options));
    }

    @Override
    public Mono<Boolean> cfAdd(K key, V item) {
        return this.createMono(() -> this.bloomCommandBuilder.cfAdd(key, item));
    }

    @Override
    public Mono<Boolean> cfAddNx(K key, V item) {
        return this.createMono(() -> this.bloomCommandBuilder.cfAddNx(key, item));
    }

    @Override
    public Mono<Long> cfCount(K key, V item) {
        return this.createMono(() -> this.bloomCommandBuilder.cfCount(key, item));
    }

    @Override
    public Mono<Boolean> cfDel(K key, V item) {
        return this.createMono(() -> this.bloomCommandBuilder.cfDel(key, item));
    }

    @Override
    public Mono<Boolean> cfExists(K key, V item) {
        return this.createMono(() -> this.bloomCommandBuilder.cfExists(key, item));
    }

    @Override
    public Mono<CuckooFilter> cfInfo(K key) {
        return this.createMono(() -> this.bloomCommandBuilder.cfInfo(key));
    }

    @Override
    public Flux<Long> cfInsert(K key, V ... items) {
        return this.createDissolvingFlux(() -> this.bloomCommandBuilder.cfInsert(key, items));
    }

    @Override
    public Flux<Long> cfInsert(K key, CuckooFilterInsertOptions options, V ... items) {
        return this.createDissolvingFlux(() -> this.bloomCommandBuilder.cfInsert(key, items, options));
    }

    @Override
    public Flux<Long> cfInsertNx(K key, V ... items) {
        return this.createDissolvingFlux(() -> this.bloomCommandBuilder.cfInsertNx(key, items));
    }

    @Override
    public Flux<Long> cfInsertNx(K key, CuckooFilterInsertOptions options, V ... items) {
        return this.createDissolvingFlux(() -> this.bloomCommandBuilder.cfInsertNx(key, items, options));
    }

    @Override
    public Flux<Boolean> cfMExists(K key, V ... items) {
        return this.createDissolvingFlux(() -> this.bloomCommandBuilder.cfMExists(key, items));
    }

    @Override
    public Mono<String> cfReserve(K key, long capacity) {
        return this.cfReserve(key, capacity, null);
    }

    @Override
    public Mono<String> cfReserve(K key, long capacity, CuckooFilterReserveOptions options) {
        return this.createMono(() -> this.bloomCommandBuilder.cfReserve(key, capacity, options));
    }

    @Override
    public Mono<Long> cmsIncrBy(K key, V item, long increment) {
        return this.createMono(() -> this.bloomCommandBuilder.cmsIncrBy(key, item, increment));
    }

    @Override
    public Flux<Long> cmsIncrBy(K key, LongScoredValue<V> ... itemIncrements) {
        return this.createDissolvingFlux(() -> this.bloomCommandBuilder.cmsIncrBy(key, itemIncrements));
    }

    @Override
    public Mono<String> cmsInitByProb(K key, double error, double probability) {
        return this.createMono(() -> this.bloomCommandBuilder.cmsInitByProb(key, error, probability));
    }

    @Override
    public Mono<String> cmsInitByDim(K key, long width, long depth) {
        return this.createMono(() -> this.bloomCommandBuilder.cmsInitByDim(key, width, depth));
    }

    @Override
    public Flux<Long> cmsQuery(K key, V ... items) {
        return this.createDissolvingFlux(() -> this.bloomCommandBuilder.cmsQuery(key, items));
    }

    @Override
    public Mono<String> cmsMerge(K destKey, K ... keys) {
        return this.createMono(() -> this.bloomCommandBuilder.cmsMerge(destKey, keys));
    }

    @Override
    public Mono<String> cmsMerge(K destKey, LongScoredValue<K> ... sourceKeyWeights) {
        return this.createMono(() -> this.bloomCommandBuilder.cmsMerge(destKey, sourceKeyWeights));
    }

    @Override
    public Mono<CmsInfo> cmsInfo(K key) {
        return this.createMono(() -> this.bloomCommandBuilder.cmsInfo(key));
    }
}

