/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.bloom;

import com.redis.lettucemod.protocol.BloomCommandKeyword;
import io.lettuce.core.CompositeArgument;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class BloomFilterInsertOptions
implements CompositeArgument {
    private OptionalLong capacity = OptionalLong.empty();
    private OptionalDouble error = OptionalDouble.empty();
    private boolean nonScaling;
    private boolean noCreate;
    private OptionalInt expansion = OptionalInt.empty();

    public BloomFilterInsertOptions() {
    }

    private BloomFilterInsertOptions(Builder builder) {
        this.capacity = builder.capacity;
        this.error = builder.error;
        this.noCreate = builder.noCreate;
        this.nonScaling = builder.nonScaling;
        this.expansion = builder.expansion;
    }

    public OptionalLong getCapacity() {
        return this.capacity;
    }

    public void setCapacity(OptionalLong capacity) {
        this.capacity = capacity;
    }

    public OptionalDouble getError() {
        return this.error;
    }

    public void setError(OptionalDouble error) {
        this.error = error;
    }

    public boolean isNonScaling() {
        return this.nonScaling;
    }

    public void setNonScaling(boolean nonScaling) {
        this.nonScaling = nonScaling;
    }

    public boolean isNoCreate() {
        return this.noCreate;
    }

    public void setNoCreate(boolean noCreate) {
        this.noCreate = noCreate;
    }

    public OptionalInt getExpansion() {
        return this.expansion;
    }

    public void setExpansion(OptionalInt expansion) {
        this.expansion = expansion;
    }

    public <K, V> void build(CommandArgs<K, V> args) {
        this.capacity.ifPresent(c -> args.add((ProtocolKeyword)BloomCommandKeyword.CAPACITY).add(c));
        this.error.ifPresent(e -> args.add((ProtocolKeyword)BloomCommandKeyword.ERROR).add(e));
        this.expansion.ifPresent(e -> args.add((ProtocolKeyword)BloomCommandKeyword.EXPANSION).add((long)e));
        if (this.noCreate) {
            args.add((ProtocolKeyword)BloomCommandKeyword.NOCREATE);
        }
        if (this.nonScaling) {
            args.add((ProtocolKeyword)BloomCommandKeyword.NONSCALING);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OptionalLong capacity = OptionalLong.empty();
        private OptionalDouble error = OptionalDouble.empty();
        private boolean nonScaling;
        private boolean noCreate;
        private OptionalInt expansion = OptionalInt.empty();

        public Builder capacity(long capacity) {
            this.capacity = OptionalLong.of(capacity);
            return this;
        }

        public Builder error(double error) {
            this.error = OptionalDouble.of(error);
            return this;
        }

        public Builder nonScaling(boolean nonScaling) {
            this.nonScaling = nonScaling;
            return this;
        }

        public Builder noCreate(boolean noCreate) {
            this.noCreate = noCreate;
            return this;
        }

        public Builder expansion(int expansion) {
            this.expansion = OptionalInt.of(expansion);
            return this;
        }

        public BloomFilterInsertOptions build() {
            return new BloomFilterInsertOptions(this);
        }
    }
}

