/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.output;

import com.redis.lettucemod.output.OutputFactory;
import io.lettuce.core.KeyValue;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.ListSubscriber;
import io.lettuce.core.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class TopKListWithScoresOutput<K, V>
extends CommandOutput<K, V, List<KeyValue<String, Long>>>
implements StreamingOutput<KeyValue<String, Long>> {
    private String field;
    private boolean initalized;
    private StreamingOutput.Subscriber<KeyValue<String, Long>> subscriber;

    public TopKListWithScoresOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
        this.setSubscriber((StreamingOutput.Subscriber<KeyValue<String, Long>>)ListSubscriber.instance());
    }

    public void set(ByteBuffer buffer) {
        this.field = this.decodeString(buffer);
    }

    public void set(long integer) {
        this.subscriber.onNext((Collection)this.output, (Object)KeyValue.just((Object)this.field, (Object)integer));
    }

    public void multi(int count) {
        if (!this.initalized) {
            this.output = OutputFactory.newList(count);
            this.initalized = true;
        }
    }

    public void setSubscriber(StreamingOutput.Subscriber<KeyValue<String, Long>> subscriber) {
        LettuceAssert.notNull(subscriber, (String)"Subscriber must not be null");
        this.subscriber = subscriber;
    }

    public StreamingOutput.Subscriber<KeyValue<String, Long>> getSubscriber() {
        return this.subscriber;
    }
}

