/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.timeseries;

import com.redis.lettucemod.protocol.TimeSeriesCommandKeyword;
import com.redis.lettucemod.timeseries.BaseOptions;
import com.redis.lettucemod.timeseries.DuplicatePolicy;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.util.Optional;

public class AlterOptions<K, V>
extends BaseOptions<K, V> {
    private final Optional<DuplicatePolicy> duplicatePolicy;

    protected AlterOptions(Builder<K, V> builder) {
        super(builder);
        this.duplicatePolicy = ((Builder)builder).duplicatePolicy;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        super.build(args);
        this.duplicatePolicy.ifPresent(p -> args.add((ProtocolKeyword)TimeSeriesCommandKeyword.DUPLICATE_POLICY).add((ProtocolKeyword)p.getKeyword()));
    }

    public static class Builder<K, V>
    extends BaseOptions.Builder<K, V, Builder<K, V>> {
        private Optional<DuplicatePolicy> duplicatePolicy = Optional.empty();

        public Builder<K, V> policy(DuplicatePolicy policy) {
            this.duplicatePolicy = Optional.of(policy);
            return this;
        }
    }
}

