/*
 * Decompiled with CFR 0.152.
 */
package io.redisearch.client;

import io.redisearch.AggregationResult;
import io.redisearch.Document;
import io.redisearch.Keywords;
import io.redisearch.Query;
import io.redisearch.Schema;
import io.redisearch.SearchResult;
import io.redisearch.Suggestion;
import io.redisearch.aggregation.AggregationBuilder;
import io.redisearch.aggregation.AggregationRequest;
import io.redisearch.client.AddOptions;
import io.redisearch.client.AutoCompleter;
import io.redisearch.client.Commands;
import io.redisearch.client.ConfigOption;
import io.redisearch.client.IndexDefinition;
import io.redisearch.client.SuggestionOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.Response;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.util.Pool;
import redis.clients.jedis.util.SafeEncoder;

public class Client
implements io.redisearch.Client {
    private final String indexName;
    private final byte[] endocdedIndexName;
    private final Pool<Jedis> pool;
    private final Jedis jedis;
    protected Commands.CommandProvider commands;

    public Client(String indexName, Pool<Jedis> pool) {
        this.indexName = indexName;
        this.endocdedIndexName = SafeEncoder.encode((String)indexName);
        this.jedis = null;
        this.pool = pool;
        this.commands = new Commands.SingleNodeCommands();
    }

    public Client(String indexName, Jedis jedis) {
        this.indexName = indexName;
        this.endocdedIndexName = SafeEncoder.encode((String)indexName);
        this.jedis = jedis;
        this.pool = null;
        this.commands = new Commands.SingleNodeCommands();
    }

    public Client(String indexName, String host, int port) {
        this(indexName, host, port, 500, 100);
    }

    public Client(String indexName, String host, int port, int timeout, int poolSize) {
        this(indexName, host, port, timeout, poolSize, null);
    }

    public Client(String indexName, String host, int port, int timeout, int poolSize, String password) {
        this(indexName, (Pool<Jedis>)new JedisPool((GenericObjectPoolConfig)Client.initPoolConfig(poolSize), host, port, timeout, password));
    }

    public Client(String indexName, String master, Set<String> sentinels, int timeout, int poolSize, String password) {
        this(indexName, (Pool<Jedis>)new JedisSentinelPool(master, sentinels, (GenericObjectPoolConfig)Client.initPoolConfig(poolSize), timeout, password));
    }

    public Client(String indexName, String masterName, Set<String> sentinels, int timeout, int poolSize) {
        this(indexName, masterName, sentinels, timeout, poolSize, null);
    }

    public Client(String indexName, String masterName, Set<String> sentinels) {
        this(indexName, masterName, sentinels, 500, 100);
    }

    private static void handleListMapping(List<Object> items, KVHandler handler, boolean decode) {
        for (int i = 0; i < items.size(); i += 2) {
            String key = SafeEncoder.encode((byte[])((byte[])items.get(i)));
            Object val = items.get(i + 1);
            if (decode) {
                val = SafeEncoder.encodeObject((Object)val);
            }
            handler.apply(key, val);
        }
    }

    @Deprecated
    Jedis _conn() {
        return this.connection();
    }

    @Override
    public Jedis connection() {
        return this.jedis != null ? this.jedis : (Jedis)this.pool.getResource();
    }

    private BinaryClient sendCommand(Jedis conn, ProtocolCommand provider, String ... args) {
        redis.clients.jedis.Client client = conn.getClient();
        client.sendCommand(provider, args);
        return client;
    }

    private BinaryClient sendCommand(Jedis conn, ProtocolCommand provider, byte[] ... args) {
        redis.clients.jedis.Client client = conn.getClient();
        client.sendCommand(provider, args);
        return client;
    }

    private static JedisPoolConfig initPoolConfig(int poolSize) {
        JedisPoolConfig conf = new JedisPoolConfig();
        conf.setMaxTotal(poolSize);
        conf.setTestOnBorrow(false);
        conf.setTestOnReturn(false);
        conf.setTestOnCreate(false);
        conf.setTestWhileIdle(false);
        conf.setMinEvictableIdleTimeMillis(60000L);
        conf.setTimeBetweenEvictionRunsMillis(30000L);
        conf.setNumTestsPerEvictionRun(-1);
        conf.setFairness(true);
        return conf;
    }

    @Override
    public boolean createIndex(Schema schema, IndexOptions options) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.indexName);
        options.serializeRedisArgs(args);
        args.add(Keywords.SCHEMA.name());
        for (Schema.Field f : schema.fields) {
            f.serializeRedisArgs(args);
        }
        try (Jedis conn = this.connection();){
            String rep = this.sendCommand(conn, this.commands.getCreateCommand(), args.toArray(new String[args.size()])).getStatusCodeReply();
            boolean bl = rep.equals("OK");
            return bl;
        }
    }

    @Override
    public boolean alterIndex(Schema.Field ... fields) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.indexName);
        args.add(Keywords.SCHEMA.name());
        args.add(Keywords.ADD.name());
        for (Schema.Field f : fields) {
            f.serializeRedisArgs(args);
        }
        try (Jedis conn = this.connection();){
            String rep = this.sendCommand(conn, this.commands.getAlterCommand(), args.toArray(new String[args.size()])).getStatusCodeReply();
            boolean bl = rep.equals("OK");
            return bl;
        }
    }

    @Override
    public boolean setConfig(ConfigOption option, String value) {
        try (Jedis conn = this.connection();){
            String rep = this.sendCommand(conn, this.commands.getConfigCommand(), Keywords.SET.getRaw(), option.getRaw(), SafeEncoder.encode((String)value)).getStatusCodeReply();
            boolean bl = rep.equals("OK");
            return bl;
        }
    }

    @Override
    public String getConfig(ConfigOption option) {
        try (Jedis conn = this.connection();){
            List objects = this.sendCommand(conn, this.commands.getConfigCommand(), Keywords.GET.getRaw(), option.getRaw()).getObjectMultiBulkReply();
            if (objects != null && !objects.isEmpty()) {
                List kvs = (List)objects.get(0);
                byte[] val = (byte[])kvs.get(1);
                String string = val == null ? null : SafeEncoder.encode((byte[])val);
                return string;
            }
        }
        return null;
    }

    @Override
    public Map<String, String> getAllConfig() {
        try (Jedis conn = this.connection();){
            List objects = this.sendCommand(conn, this.commands.getConfigCommand(), Keywords.GET.getRaw(), ConfigOption.ALL.getRaw()).getObjectMultiBulkReply();
            HashMap<String, String> configs = new HashMap<String, String>(objects.size());
            for (Object object : objects) {
                List kvs = (List)object;
                byte[] val = (byte[])kvs.get(1);
                configs.put(SafeEncoder.encode((byte[])((byte[])kvs.get(0))), val == null ? null : SafeEncoder.encode((byte[])val));
            }
            HashMap<String, String> hashMap = configs;
            return hashMap;
        }
    }

    @Override
    public boolean addAlias(String name) {
        try (Jedis conn = this.connection();){
            String rep = this.sendCommand(conn, this.commands.getAliasAddCommand(), name, this.indexName).getStatusCodeReply();
            boolean bl = rep.equals("OK");
            return bl;
        }
    }

    @Override
    public boolean updateAlias(String name) {
        try (Jedis conn = this.connection();){
            String rep = this.sendCommand(conn, this.commands.getAliasUpdateCommand(), name, this.indexName).getStatusCodeReply();
            boolean bl = rep.equals("OK");
            return bl;
        }
    }

    @Override
    public boolean deleteAlias(String name) {
        try (Jedis conn = this.connection();){
            String rep = this.sendCommand(conn, this.commands.getAliasDelCommand(), name).getStatusCodeReply();
            boolean bl = rep.equals("OK");
            return bl;
        }
    }

    @Override
    public SearchResult[] searchBatch(Query ... queries) {
        Response[] responses = new Response[queries.length];
        try (Jedis conn = this.connection();){
            Pipeline pipelined = conn.pipelined();
            for (int i = 0; i < queries.length; ++i) {
                Query q = queries[i];
                ArrayList<byte[]> args = new ArrayList<byte[]>(4);
                args.add(this.endocdedIndexName);
                q.serializeRedisArgs(args);
                responses[i] = pipelined.sendCommand(this.commands.getSearchCommand(), (byte[][])args.toArray((T[])new byte[args.size()][]));
            }
            pipelined.sync();
            SearchResult[] results = new SearchResult[queries.length];
            for (int i = 0; i < queries.length; ++i) {
                Query q = queries[i];
                Response response = responses[i];
                results[i] = new SearchResult((List)response.get(), !q.getNoContent(), q.getWithScores(), q.getWithPayloads(), true);
            }
            SearchResult[] searchResultArray = results;
            return searchResultArray;
        }
    }

    @Override
    public SearchResult search(Query q) {
        return this.search(q, true);
    }

    @Override
    public SearchResult search(Query q, boolean decode) {
        ArrayList<byte[]> args = new ArrayList<byte[]>(4);
        args.add(this.endocdedIndexName);
        q.serializeRedisArgs(args);
        try (Jedis conn = this.connection();){
            List resp = this.sendCommand(conn, this.commands.getSearchCommand(), (byte[][])args.toArray((T[])new byte[args.size()][])).getObjectMultiBulkReply();
            SearchResult searchResult = new SearchResult(resp, !q.getNoContent(), q.getWithScores(), q.getWithPayloads(), decode);
            return searchResult;
        }
    }

    @Override
    @Deprecated
    public AggregationResult aggregate(AggregationRequest q) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(this.endocdedIndexName);
        q.serializeRedisArgs(args);
        try (Jedis conn = this.connection();){
            List resp = this.sendCommand(conn, this.commands.getAggregateCommand(), (byte[][])args.toArray((T[])new byte[args.size()][])).getObjectMultiBulkReply();
            if (q.isWithCursor()) {
                AggregationResult aggregationResult = new AggregationResult((List)resp.get(0), (Long)resp.get(1));
                return aggregationResult;
            }
            AggregationResult aggregationResult = new AggregationResult(resp);
            return aggregationResult;
        }
    }

    @Override
    public AggregationResult aggregate(AggregationBuilder q) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(this.endocdedIndexName);
        q.serializeRedisArgs(args);
        try (Jedis conn = this.connection();){
            List resp = this.sendCommand(conn, this.commands.getAggregateCommand(), (byte[][])args.toArray((T[])new byte[args.size()][])).getObjectMultiBulkReply();
            if (q.isWithCursor()) {
                AggregationResult aggregationResult = new AggregationResult((List)resp.get(0), (Long)resp.get(1));
                return aggregationResult;
            }
            AggregationResult aggregationResult = new AggregationResult(resp);
            return aggregationResult;
        }
    }

    @Override
    public String explain(Query q) {
        ArrayList<byte[]> args = new ArrayList<byte[]>(4);
        args.add(this.endocdedIndexName);
        q.serializeRedisArgs(args);
        try (Jedis conn = this.connection();){
            String string = this.sendCommand(conn, this.commands.getExplainCommand(), (byte[][])args.toArray((T[])new byte[args.size()][])).getStatusCodeReply();
            return string;
        }
    }

    @Override
    public boolean addDocument(String docId, double score, Map<String, Object> fields, boolean noSave, boolean replace, byte[] payload) {
        return this.doAddDocument(docId, score, fields, noSave, replace, false, payload, null);
    }

    private boolean doAddDocument(String docId, double score, Map<String, Object> fields, boolean noSave, boolean replace, boolean partial, byte[] payload, String filter) {
        Document doc = new Document(docId, fields, score, payload);
        AddOptions options = new AddOptions().setNosave(noSave);
        if (replace) {
            options.setReplacementPolicy(AddOptions.ReplacementPolicy.FULL, filter);
        }
        if (partial) {
            options.setReplacementPolicy(AddOptions.ReplacementPolicy.PARTIAL, filter);
        }
        return this.addDocument(doc, options);
    }

    @Override
    public boolean addDocument(Document doc) {
        return this.addDocument(doc, new AddOptions());
    }

    @Override
    public boolean addDocument(Document doc, AddOptions options) {
        try (Jedis conn = this.connection();){
            boolean bl = this.addDocument(doc, options, conn).getStatusCodeReply().equals("OK");
            return bl;
        }
    }

    @Override
    public boolean[] addDocuments(Document ... docs) {
        return this.addDocuments(new AddOptions(), docs);
    }

    @Override
    public boolean[] addDocuments(AddOptions options, Document ... docs) {
        try (Jedis conn = this.connection();){
            for (Document doc : docs) {
                this.addDocument(doc, options, conn);
            }
            List objects = conn.getClient().getMany(docs.length);
            boolean[] results = new boolean[docs.length];
            int i = 0;
            for (Object obj : objects) {
                results[i++] = !(obj instanceof JedisDataException) && SafeEncoder.encode((byte[])((byte[])obj)).equals("OK");
            }
            Object object = results;
            return object;
        }
    }

    private BinaryClient addDocument(Document doc, AddOptions options, Jedis conn) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(this.endocdedIndexName);
        args.add(SafeEncoder.encode((String)doc.getId()));
        args.add(Protocol.toByteArray((double)doc.getScore()));
        if (options.getNosave()) {
            args.add(Keywords.NOSAVE.getRaw());
        }
        if (options.getReplacementPolicy() != AddOptions.ReplacementPolicy.NONE) {
            String filter;
            args.add(Keywords.REPLACE.getRaw());
            if (options.getReplacementPolicy() == AddOptions.ReplacementPolicy.PARTIAL) {
                args.add(Keywords.PARTIAL.getRaw());
            }
            if ((filter = options.getReplacementFilter()) != null) {
                args.add(Keywords.IF.getRaw());
                args.add(SafeEncoder.encode((String)filter));
            }
        }
        if (options.getLanguage() != null && !options.getLanguage().isEmpty()) {
            args.add(Keywords.LANGUAGE.getRaw());
            args.add(SafeEncoder.encode((String)options.getLanguage()));
        }
        if (doc.getPayload() != null) {
            args.add(Keywords.PAYLOAD.getRaw());
            args.add(doc.getPayload());
        }
        args.add(Keywords.FIELDS.getRaw());
        for (Map.Entry<String, Object> entry : doc.getProperties()) {
            byte[] binaryValue;
            String key = entry.getKey();
            args.add(SafeEncoder.encode((String)key));
            Object value = entry.getValue();
            if (value == null) {
                throw new NullPointerException("Document attribute '" + key + "' is null. (Remove it, or set a value)");
            }
            if (value instanceof GeoCoordinate) {
                GeoCoordinate geo = (GeoCoordinate)value;
                byte[] lon = Protocol.toByteArray((double)geo.getLongitude());
                byte[] lat = Protocol.toByteArray((double)geo.getLatitude());
                binaryValue = new byte[lon.length + lat.length + 1];
                System.arraycopy(lon, 0, binaryValue, 0, lon.length);
                binaryValue[lon.length] = 44;
                System.arraycopy(lat, 0, binaryValue, lon.length + 1, lat.length);
            } else {
                binaryValue = value instanceof byte[] ? (byte[])value : SafeEncoder.encode((String)value.toString());
            }
            args.add(binaryValue);
        }
        return this.sendCommand(conn, this.commands.getAddCommand(), (byte[][])args.toArray((T[])new byte[args.size()][]));
    }

    @Override
    public boolean replaceDocument(String docId, double score, Map<String, Object> fields) {
        return this.doAddDocument(docId, score, fields, false, true, false, null, null);
    }

    @Override
    public boolean replaceDocument(String docId, double score, Map<String, Object> fields, String filter) {
        return this.doAddDocument(docId, score, fields, false, true, false, null, filter);
    }

    @Override
    public boolean updateDocument(String docId, double score, Map<String, Object> fields) {
        return this.doAddDocument(docId, score, fields, false, true, true, null, null);
    }

    @Override
    public boolean updateDocument(String docId, double score, Map<String, Object> fields, String filter) {
        return this.doAddDocument(docId, score, fields, false, true, true, null, filter);
    }

    @Override
    public boolean addDocument(String docId, double score, Map<String, Object> fields) {
        return this.addDocument(docId, score, fields, false, false, null);
    }

    @Override
    public boolean addDocument(String docId, Map<String, Object> fields) {
        return this.addDocument(docId, 1.0, fields, false, false, null);
    }

    @Override
    @Deprecated
    public boolean addHash(String docId, double score, boolean replace) {
        ArrayList<String> args = new ArrayList<String>(4);
        args.add(this.indexName);
        args.add(docId);
        args.add(Double.toString(score));
        if (replace) {
            args.add(Keywords.REPLACE.name());
        }
        try (Jedis conn = this.connection();){
            String resp = this.sendCommand(conn, this.commands.getAddHashCommand(), args.toArray(new String[args.size()])).getStatusCodeReply();
            boolean bl = resp.equals("OK");
            return bl;
        }
    }

    @Override
    public Map<String, Object> getInfo() {
        List res;
        try (Jedis conn = this.connection();){
            res = this.sendCommand(conn, this.commands.getInfoCommand(), new byte[][]{this.endocdedIndexName}).getObjectMultiBulkReply();
        }
        HashMap<String, Object> info = new HashMap<String, Object>();
        Client.handleListMapping(res, info::put, true);
        return info;
    }

    @Override
    public boolean[] deleteDocuments(boolean deleteDocuments, String ... docIds) {
        try (Jedis conn = this.connection();){
            for (String docId : docIds) {
                this.deleteDocument(docId, deleteDocuments, conn);
            }
            List objects = conn.getClient().getMany(docIds.length);
            boolean[] results = new boolean[docIds.length];
            int i = 0;
            for (Object obj : objects) {
                results[i++] = !(obj instanceof JedisDataException) && (Long)obj == 1L;
            }
            Object object = results;
            return object;
        }
    }

    @Override
    public boolean deleteDocument(String docId) {
        return this.deleteDocument(docId, false);
    }

    @Override
    public boolean deleteDocument(String docId, boolean deleteDocument) {
        try (Jedis conn = this.connection();){
            boolean bl = this.deleteDocument(docId, deleteDocument, conn).getIntegerReply() == 1L;
            return bl;
        }
    }

    private BinaryClient deleteDocument(String docId, boolean deleteDocument, Jedis conn) {
        if (deleteDocument) {
            return this.sendCommand(conn, this.commands.getDelCommand(), this.endocdedIndexName, SafeEncoder.encode((String)docId), Keywords.DD.getRaw());
        }
        return this.sendCommand(conn, this.commands.getDelCommand(), this.endocdedIndexName, SafeEncoder.encode((String)docId));
    }

    @Override
    public Document getDocument(String docId) {
        return this.getDocument(docId, true);
    }

    @Override
    public Document getDocument(String docId, boolean decode) {
        Document d = new Document(docId);
        try (Jedis conn = this.connection();){
            List res = this.sendCommand(conn, this.commands.getGetCommand(), this.indexName, docId).getObjectMultiBulkReply();
            if (res == null) {
                Document document = null;
                return document;
            }
            Client.handleListMapping(res, d::set, decode);
            Document document = d;
            return document;
        }
    }

    @Override
    public List<Document> getDocuments(String ... docIds) {
        return this.getDocuments(true, docIds);
    }

    @Override
    public List<Document> getDocuments(boolean decode, String ... docIds) {
        int len = docIds.length;
        if (len == 0) {
            return new ArrayList<Document>(0);
        }
        byte[][] args = new byte[docIds.length + 1][];
        args[0] = this.endocdedIndexName;
        for (int i = 0; i < len; ++i) {
            args[i + 1] = SafeEncoder.encode((String)docIds[i]);
        }
        ArrayList<Document> documents = new ArrayList<Document>(len);
        try (Jedis conn = this.connection();){
            List res = this.sendCommand(conn, this.commands.getMGetCommand(), args).getObjectMultiBulkReply();
            for (int i = 0; i < len; ++i) {
                List line = (List)res.get(i);
                if (line == null) {
                    documents.add(null);
                    continue;
                }
                Document doc = new Document(docIds[i]);
                Client.handleListMapping(line, doc::set, decode);
                documents.add(doc);
            }
            ArrayList<Document> arrayList = documents;
            return arrayList;
        }
    }

    @Override
    public boolean dropIndex() {
        return this.dropIndex(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean dropIndex(boolean missingOk) {
        try (Jedis conn = this.connection();){
            String res = this.sendCommand(conn, this.commands.getDropCommand(), new byte[][]{this.endocdedIndexName}).getStatusCodeReply();
            boolean bl = res.equals("OK");
            return bl;
        }
        catch (JedisDataException ex) {
            if (!missingOk) throw ex;
            if (!ex.getMessage().toLowerCase().contains("unknown")) throw ex;
            return false;
        }
    }

    @Override
    public Long addSuggestion(Suggestion suggestion, boolean increment) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.indexName);
        args.add(suggestion.getString());
        args.add(Double.toString(suggestion.getScore()));
        if (increment) {
            args.add(Keywords.INCR.name());
        }
        if (suggestion.getPayload() != null) {
            args.add(Keywords.PAYLOAD.name());
            args.add(suggestion.getPayload());
        }
        try (Jedis conn = this.connection();){
            Long l = this.sendCommand(conn, (ProtocolCommand)AutoCompleter.Command.SUGADD, args.toArray(new String[args.size()])).getIntegerReply();
            return l;
        }
    }

    @Override
    public List<Suggestion> getSuggestion(String prefix, SuggestionOptions suggestionOptions) {
        Optional<SuggestionOptions.With> options;
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.indexName);
        args.add(prefix);
        args.add(Keywords.MAX.name());
        args.add(Integer.toString(suggestionOptions.getMax()));
        if (suggestionOptions.isFuzzy()) {
            args.add(Keywords.FUZZY.name());
        }
        if (!(options = suggestionOptions.getWith()).isPresent()) {
            return this.getSuggestions(args);
        }
        SuggestionOptions.With with = options.get();
        args.addAll(Arrays.asList(with.getFlags()));
        switch (with) {
            case PAYLOAD_AND_SCORES: {
                return this.getSuggestionsWithPayloadAndScores(args);
            }
            case PAYLOAD: {
                return this.getSuggestionsWithPayload(args);
            }
        }
        return this.getSuggestionsWithScores(args);
    }

    @Override
    public Long deleteSuggestion(String entry) {
        try (Jedis conn = this.connection();){
            Long l = this.sendCommand(conn, (ProtocolCommand)AutoCompleter.Command.SUGDEL, this.indexName, entry).getIntegerReply();
            return l;
        }
    }

    @Override
    public Long getSuggestionLength() {
        try (Jedis conn = this.connection();){
            Long l = this.sendCommand(conn, (ProtocolCommand)AutoCompleter.Command.SUGLEN, this.indexName).getIntegerReply();
            return l;
        }
    }

    @Override
    public boolean cursorDelete(long cursorId) {
        try (Jedis conn = this.connection();){
            String rep = this.sendCommand(conn, this.commands.getCursorCommand(), Keywords.DELETE.getRaw(), this.endocdedIndexName, Protocol.toByteArray((long)cursorId)).getStatusCodeReply();
            boolean bl = rep.equals("OK");
            return bl;
        }
    }

    @Override
    public AggregationResult cursorRead(long cursorId, int count) {
        try (Jedis conn = this.connection();){
            List resp = this.sendCommand(conn, this.commands.getCursorCommand(), Keywords.READ.getRaw(), this.endocdedIndexName, Protocol.toByteArray((long)cursorId), Keywords.COUNT.getRaw(), Protocol.toByteArray((int)count)).getObjectMultiBulkReply();
            AggregationResult aggregationResult = new AggregationResult((List)resp.get(0), (Long)resp.get(1));
            return aggregationResult;
        }
    }

    private List<Suggestion> getSuggestions(List<String> args) {
        ArrayList<Suggestion> list = new ArrayList<Suggestion>();
        try (Jedis conn = this.connection();){
            List result = this.sendCommand(conn, (ProtocolCommand)AutoCompleter.Command.SUGGET, args.toArray(new String[args.size()])).getMultiBulkReply();
            result.forEach(str -> list.add(Suggestion.builder().str((String)str).build()));
        }
        return list;
    }

    private List<Suggestion> getSuggestionsWithScores(List<String> args) {
        ArrayList<Suggestion> list = new ArrayList<Suggestion>();
        try (Jedis conn = this.connection();){
            List result = this.sendCommand(conn, (ProtocolCommand)AutoCompleter.Command.SUGGET, args.toArray(new String[args.size()])).getMultiBulkReply();
            for (int i = 1; i < result.size() + 1; ++i) {
                if (i % 2 != 0) continue;
                Suggestion.Builder builder = Suggestion.builder();
                builder.str((String)result.get(i - 2));
                builder.score(Double.parseDouble((String)result.get(i - 1)));
                list.add(builder.build());
            }
        }
        return list;
    }

    private List<Suggestion> getSuggestionsWithPayload(List<String> args) {
        ArrayList<Suggestion> list = new ArrayList<Suggestion>();
        try (Jedis conn = this.connection();){
            List result = this.sendCommand(conn, (ProtocolCommand)AutoCompleter.Command.SUGGET, args.toArray(new String[args.size()])).getMultiBulkReply();
            for (int i = 1; i < result.size() + 1; ++i) {
                if (i % 2 != 0) continue;
                Suggestion.Builder builder = Suggestion.builder();
                builder.str((String)result.get(i - 2));
                builder.payload((String)result.get(i - 1));
                list.add(builder.build());
            }
        }
        return list;
    }

    private List<Suggestion> getSuggestionsWithPayloadAndScores(List<String> args) {
        ArrayList<Suggestion> list = new ArrayList<Suggestion>();
        try (Jedis conn = this.connection();){
            List result = this.sendCommand(conn, (ProtocolCommand)AutoCompleter.Command.SUGGET, args.toArray(new String[args.size()])).getMultiBulkReply();
            for (int i = 1; i < result.size() + 1; ++i) {
                if (i % 3 != 0) continue;
                Suggestion.Builder builder = Suggestion.builder();
                builder.str((String)result.get(i - 3));
                builder.score(Double.parseDouble((String)result.get(i - 2)));
                builder.payload((String)result.get(i - 1));
                list.add(builder.build());
            }
        }
        return list;
    }

    @Override
    @Deprecated
    public long addSynonym(String ... terms) {
        String[] args = new String[terms.length + 1];
        args[0] = this.indexName;
        System.arraycopy(terms, 0, args, 1, terms.length);
        try (Jedis conn = this.connection();){
            long l = this.sendCommand(conn, this.commands.getSynAddCommand(), args).getIntegerReply();
            return l;
        }
    }

    @Override
    @Deprecated
    public boolean updateSynonym(long synonymGroupId, String ... terms) {
        return this.updateSynonym(Long.toString(synonymGroupId), terms);
    }

    @Override
    public boolean updateSynonym(String synonymGroupId, String ... terms) {
        String[] args = new String[terms.length + 2];
        args[0] = this.indexName;
        args[1] = synonymGroupId;
        System.arraycopy(terms, 0, args, 2, terms.length);
        try (Jedis conn = this.connection();){
            String rep = this.sendCommand(conn, this.commands.getSynUpdateCommand(), args).getStatusCodeReply();
            boolean bl = rep.equals("OK");
            return bl;
        }
    }

    @Override
    public Map<String, List<String>> dumpSynonym() {
        try (Jedis conn = this.connection();){
            List res = this.sendCommand(conn, this.commands.getSynDumpCommand(), this.indexName).getObjectMultiBulkReply();
            HashMap<String, List<String>> dump = new HashMap<String, List<String>>(res.size() / 2);
            for (int i = 0; i < res.size(); i += 2) {
                List groups = ((List)res.get(i + 1)).stream().map(x -> x instanceof Long ? String.valueOf(x) : SafeEncoder.encode((byte[])((byte[])x))).collect(Collectors.toList());
                dump.put(SafeEncoder.encode((byte[])((byte[])res.get(i))), groups);
            }
            HashMap<String, List<String>> hashMap = dump;
            return hashMap;
        }
    }

    @Override
    public void close() {
        if (this.pool != null) {
            this.pool.close();
        }
        if (this.jedis != null) {
            this.jedis.close();
        }
    }

    public static class IndexOptions {
        public static final int USE_TERM_OFFSETS = 1;
        public static final int KEEP_FIELD_FLAGS = 2;
        public static final int KEEP_TERM_FREQUENCIES = 8;
        public static final int DEFAULT_FLAGS = 11;
        private final int flags;
        private List<String> stopwords;
        private long expire = 0L;
        private IndexDefinition definition;

        public IndexOptions(int flags) {
            this.flags = flags;
        }

        public static IndexOptions defaultOptions() {
            return new IndexOptions(11);
        }

        @Deprecated
        public static IndexOptions Default() {
            return IndexOptions.defaultOptions();
        }

        public IndexOptions setStopwords(String ... stopwords) {
            this.stopwords = Arrays.asList(stopwords);
            return this;
        }

        @Deprecated
        public IndexOptions SetStopwords(String ... stopwords) {
            return this.setStopwords(stopwords);
        }

        public IndexOptions setNoStopwords() {
            this.stopwords = new ArrayList<String>(0);
            return this;
        }

        @Deprecated
        public IndexOptions SetNoStopwords() {
            return this.setNoStopwords();
        }

        public IndexOptions setTemporary(long expire) {
            this.expire = expire;
            return this;
        }

        public IndexDefinition getDefinition() {
            return this.definition;
        }

        public IndexOptions setDefinition(IndexDefinition definition) {
            this.definition = definition;
            return this;
        }

        public void serializeRedisArgs(List<String> args) {
            if (this.definition != null) {
                this.definition.serializeRedisArgs(args);
            }
            if ((this.flags & 1) == 0) {
                args.add(Keywords.NOOFFSETS.name());
            }
            if ((this.flags & 2) == 0) {
                args.add(Keywords.NOFIELDS.name());
            }
            if ((this.flags & 8) == 0) {
                args.add(Keywords.NOFREQS.name());
            }
            if (this.expire > 0L) {
                args.add(Keywords.TEMPORARY.name());
                args.add(Long.toString(this.expire));
            }
            if (this.stopwords != null) {
                args.add(Keywords.STOPWORDS.name());
                args.add(Integer.toString(this.stopwords.size()));
                if (!this.stopwords.isEmpty()) {
                    args.addAll(this.stopwords);
                }
            }
        }
    }

    @FunctionalInterface
    private static interface KVHandler {
        public void apply(String var1, Object var2);
    }
}

