/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.AdcreativeTemplateListGetResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AdcreativeTemplateListApi {
    private ApiClient apiClient;

    public AdcreativeTemplateListApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AdcreativeTemplateListApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call adcreativeTemplateListGetCall(Long accountId, String siteSet, String campaignType, String promotedObjectType, List<String> dynamicAbilityType, Boolean isDynamicCreative, List<Long> wechatSceneSpecPosition, Long adcreativeTemplateId, Long page, Long pageSize, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/adcreative_template_list/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (siteSet != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("site_set", siteSet));
        }
        if (campaignType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("campaign_type", campaignType));
        }
        if (promotedObjectType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("promoted_object_type", promotedObjectType));
        }
        if (dynamicAbilityType != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "dynamic_ability_type", dynamicAbilityType));
        }
        if (isDynamicCreative != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("is_dynamic_creative", isDynamicCreative));
        }
        if (wechatSceneSpecPosition != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "wechat_scene_spec_position", wechatSceneSpecPosition));
        }
        if (adcreativeTemplateId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("adcreative_template_id", adcreativeTemplateId));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call adcreativeTemplateListGetValidateBeforeCall(Long accountId, String siteSet, String campaignType, String promotedObjectType, List<String> dynamicAbilityType, Boolean isDynamicCreative, List<Long> wechatSceneSpecPosition, Long adcreativeTemplateId, Long page, Long pageSize, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling adcreativeTemplateListGet(Async)");
        }
        Call call = this.adcreativeTemplateListGetCall(accountId, siteSet, campaignType, promotedObjectType, dynamicAbilityType, isDynamicCreative, wechatSceneSpecPosition, adcreativeTemplateId, page, pageSize, fields, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public AdcreativeTemplateListGetResponse adcreativeTemplateListGet(Long accountId, String siteSet, String campaignType, String promotedObjectType, List<String> dynamicAbilityType, Boolean isDynamicCreative, List<Long> wechatSceneSpecPosition, Long adcreativeTemplateId, Long page, Long pageSize, List<String> fields, String ... headerPair) throws ApiException {
        ApiResponse<AdcreativeTemplateListGetResponse> resp = this.adcreativeTemplateListGetWithHttpInfo(accountId, siteSet, campaignType, promotedObjectType, dynamicAbilityType, isDynamicCreative, wechatSceneSpecPosition, adcreativeTemplateId, page, pageSize, fields, headerPair);
        return resp.getData();
    }

    public ApiResponse<AdcreativeTemplateListGetResponse> adcreativeTemplateListGetWithHttpInfo(Long accountId, String siteSet, String campaignType, String promotedObjectType, List<String> dynamicAbilityType, Boolean isDynamicCreative, List<Long> wechatSceneSpecPosition, Long adcreativeTemplateId, Long page, Long pageSize, List<String> fields, String ... headerPair) throws ApiException {
        Call call = this.adcreativeTemplateListGetValidateBeforeCall(accountId, siteSet, campaignType, promotedObjectType, dynamicAbilityType, isDynamicCreative, wechatSceneSpecPosition, adcreativeTemplateId, page, pageSize, fields, null, null, headerPair);
        Type localVarReturnType = new TypeToken<AdcreativeTemplateListGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call adcreativeTemplateListGetAsync(Long accountId, String siteSet, String campaignType, String promotedObjectType, List<String> dynamicAbilityType, Boolean isDynamicCreative, List<Long> wechatSceneSpecPosition, Long adcreativeTemplateId, Long page, Long pageSize, List<String> fields, final ApiCallback<AdcreativeTemplateListGetResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.adcreativeTemplateListGetValidateBeforeCall(accountId, siteSet, campaignType, promotedObjectType, dynamicAbilityType, isDynamicCreative, wechatSceneSpecPosition, adcreativeTemplateId, page, pageSize, fields, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<AdcreativeTemplateListGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

