/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.CustomTagFilesAddResponse;
import com.tencent.ads.model.CustomTagFilesGetResponse;
import com.tencent.ads.model.FilteringStruct;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CustomTagFilesApi {
    private ApiClient apiClient;

    public CustomTagFilesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomTagFilesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call customTagFilesAddCall(Long accountId, String userIdType, Long tagId, File file, String operationType, String openAppId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/custom_tag_files/add";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accountId != null) {
            localVarFormParams.put("account_id", accountId);
        }
        if (userIdType != null) {
            localVarFormParams.put("user_id_type", userIdType);
        }
        if (tagId != null) {
            localVarFormParams.put("tag_id", tagId);
        }
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if (operationType != null) {
            localVarFormParams.put("operation_type", operationType);
        }
        if (openAppId != null) {
            localVarFormParams.put("open_app_id", openAppId);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call customTagFilesAddValidateBeforeCall(Long accountId, String userIdType, Long tagId, File file, String operationType, String openAppId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling customTagFilesAdd(Async)");
        }
        if (userIdType == null) {
            throw new ApiException("Missing the required parameter 'userIdType' when calling customTagFilesAdd(Async)");
        }
        if (tagId == null) {
            throw new ApiException("Missing the required parameter 'tagId' when calling customTagFilesAdd(Async)");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling customTagFilesAdd(Async)");
        }
        Call call = this.customTagFilesAddCall(accountId, userIdType, tagId, file, operationType, openAppId, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public CustomTagFilesAddResponse customTagFilesAdd(Long accountId, String userIdType, Long tagId, File file, String operationType, String openAppId, String ... headerPair) throws ApiException {
        ApiResponse<CustomTagFilesAddResponse> resp = this.customTagFilesAddWithHttpInfo(accountId, userIdType, tagId, file, operationType, openAppId, headerPair);
        return resp.getData();
    }

    public ApiResponse<CustomTagFilesAddResponse> customTagFilesAddWithHttpInfo(Long accountId, String userIdType, Long tagId, File file, String operationType, String openAppId, String ... headerPair) throws ApiException {
        Call call = this.customTagFilesAddValidateBeforeCall(accountId, userIdType, tagId, file, operationType, openAppId, null, null, headerPair);
        Type localVarReturnType = new TypeToken<CustomTagFilesAddResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call customTagFilesAddAsync(Long accountId, String userIdType, Long tagId, File file, String operationType, String openAppId, final ApiCallback<CustomTagFilesAddResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.customTagFilesAddValidateBeforeCall(accountId, userIdType, tagId, file, operationType, openAppId, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<CustomTagFilesAddResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call customTagFilesGetCall(Long accountId, List<FilteringStruct> filtering, Long page, Long pageSize, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/custom_tag_files/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (filtering != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "filtering", filtering));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call customTagFilesGetValidateBeforeCall(Long accountId, List<FilteringStruct> filtering, Long page, Long pageSize, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling customTagFilesGet(Async)");
        }
        Call call = this.customTagFilesGetCall(accountId, filtering, page, pageSize, fields, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public CustomTagFilesGetResponse customTagFilesGet(Long accountId, List<FilteringStruct> filtering, Long page, Long pageSize, List<String> fields, String ... headerPair) throws ApiException {
        ApiResponse<CustomTagFilesGetResponse> resp = this.customTagFilesGetWithHttpInfo(accountId, filtering, page, pageSize, fields, headerPair);
        return resp.getData();
    }

    public ApiResponse<CustomTagFilesGetResponse> customTagFilesGetWithHttpInfo(Long accountId, List<FilteringStruct> filtering, Long page, Long pageSize, List<String> fields, String ... headerPair) throws ApiException {
        Call call = this.customTagFilesGetValidateBeforeCall(accountId, filtering, page, pageSize, fields, null, null, headerPair);
        Type localVarReturnType = new TypeToken<CustomTagFilesGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call customTagFilesGetAsync(Long accountId, List<FilteringStruct> filtering, Long page, Long pageSize, List<String> fields, final ApiCallback<CustomTagFilesGetResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.customTagFilesGetValidateBeforeCall(accountId, filtering, page, pageSize, fields, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<CustomTagFilesGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

