/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.DynamicAdImageTemplatesGetResponse;
import com.tencent.ads.model.FilteringStruct;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DynamicAdImageTemplatesApi {
    private ApiClient apiClient;

    public DynamicAdImageTemplatesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DynamicAdImageTemplatesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call dynamicAdImageTemplatesGetCall(Long accountId, Long productCatalogId, String productMode, Long dynamicAdTemplateWidth, Long dynamicAdTemplateHeight, String dynamicAdTemplateOwnershipType, List<FilteringStruct> filtering, Long page, Long pageSize, List<Long> templateIdList, String templateName, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/dynamic_ad_image_templates/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (productCatalogId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("product_catalog_id", productCatalogId));
        }
        if (productMode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("product_mode", productMode));
        }
        if (dynamicAdTemplateOwnershipType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dynamic_ad_template_ownership_type", dynamicAdTemplateOwnershipType));
        }
        if (dynamicAdTemplateWidth != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dynamic_ad_template_width", dynamicAdTemplateWidth));
        }
        if (dynamicAdTemplateHeight != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dynamic_ad_template_height", dynamicAdTemplateHeight));
        }
        if (filtering != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "filtering", filtering));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", pageSize));
        }
        if (templateIdList != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "template_id_list", templateIdList));
        }
        if (templateName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("template_name", templateName));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call dynamicAdImageTemplatesGetValidateBeforeCall(Long accountId, Long productCatalogId, String productMode, Long dynamicAdTemplateWidth, Long dynamicAdTemplateHeight, String dynamicAdTemplateOwnershipType, List<FilteringStruct> filtering, Long page, Long pageSize, List<Long> templateIdList, String templateName, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling dynamicAdImageTemplatesGet(Async)");
        }
        if (productCatalogId == null) {
            throw new ApiException("Missing the required parameter 'productCatalogId' when calling dynamicAdImageTemplatesGet(Async)");
        }
        if (productMode == null) {
            throw new ApiException("Missing the required parameter 'productMode' when calling dynamicAdImageTemplatesGet(Async)");
        }
        if (dynamicAdTemplateWidth == null) {
            throw new ApiException("Missing the required parameter 'dynamicAdTemplateWidth' when calling dynamicAdImageTemplatesGet(Async)");
        }
        if (dynamicAdTemplateHeight == null) {
            throw new ApiException("Missing the required parameter 'dynamicAdTemplateHeight' when calling dynamicAdImageTemplatesGet(Async)");
        }
        Call call = this.dynamicAdImageTemplatesGetCall(accountId, productCatalogId, productMode, dynamicAdTemplateWidth, dynamicAdTemplateHeight, dynamicAdTemplateOwnershipType, filtering, page, pageSize, templateIdList, templateName, fields, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public DynamicAdImageTemplatesGetResponse dynamicAdImageTemplatesGet(Long accountId, Long productCatalogId, String productMode, Long dynamicAdTemplateWidth, Long dynamicAdTemplateHeight, String dynamicAdTemplateOwnershipType, List<FilteringStruct> filtering, Long page, Long pageSize, List<Long> templateIdList, String templateName, List<String> fields, String ... headerPair) throws ApiException {
        ApiResponse<DynamicAdImageTemplatesGetResponse> resp = this.dynamicAdImageTemplatesGetWithHttpInfo(accountId, productCatalogId, productMode, dynamicAdTemplateWidth, dynamicAdTemplateHeight, dynamicAdTemplateOwnershipType, filtering, page, pageSize, templateIdList, templateName, fields, headerPair);
        return resp.getData();
    }

    public ApiResponse<DynamicAdImageTemplatesGetResponse> dynamicAdImageTemplatesGetWithHttpInfo(Long accountId, Long productCatalogId, String productMode, Long dynamicAdTemplateWidth, Long dynamicAdTemplateHeight, String dynamicAdTemplateOwnershipType, List<FilteringStruct> filtering, Long page, Long pageSize, List<Long> templateIdList, String templateName, List<String> fields, String ... headerPair) throws ApiException {
        Call call = this.dynamicAdImageTemplatesGetValidateBeforeCall(accountId, productCatalogId, productMode, dynamicAdTemplateWidth, dynamicAdTemplateHeight, dynamicAdTemplateOwnershipType, filtering, page, pageSize, templateIdList, templateName, fields, null, null, headerPair);
        Type localVarReturnType = new TypeToken<DynamicAdImageTemplatesGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call dynamicAdImageTemplatesGetAsync(Long accountId, Long productCatalogId, String productMode, Long dynamicAdTemplateWidth, Long dynamicAdTemplateHeight, String dynamicAdTemplateOwnershipType, List<FilteringStruct> filtering, Long page, Long pageSize, List<Long> templateIdList, String templateName, List<String> fields, final ApiCallback<DynamicAdImageTemplatesGetResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.dynamicAdImageTemplatesGetValidateBeforeCall(accountId, productCatalogId, productMode, dynamicAdTemplateWidth, dynamicAdTemplateHeight, dynamicAdTemplateOwnershipType, filtering, page, pageSize, templateIdList, templateName, fields, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<DynamicAdImageTemplatesGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

