/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.DynamicAdVideoAddRequest;
import com.tencent.ads.model.DynamicAdVideoAddResponse;
import com.tencent.ads.model.DynamicAdVideoGetResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DynamicAdVideoApi {
    private ApiClient apiClient;

    public DynamicAdVideoApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DynamicAdVideoApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call dynamicAdVideoAddCall(DynamicAdVideoAddRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        DynamicAdVideoAddRequest localVarPostBody = data;
        String localVarPath = "/dynamic_ad_video/add";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call dynamicAdVideoAddValidateBeforeCall(DynamicAdVideoAddRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling dynamicAdVideoAdd(Async)");
        }
        Call call = this.dynamicAdVideoAddCall(data, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public DynamicAdVideoAddResponse dynamicAdVideoAdd(DynamicAdVideoAddRequest data, String ... headerPair) throws ApiException {
        ApiResponse<DynamicAdVideoAddResponse> resp = this.dynamicAdVideoAddWithHttpInfo(data, headerPair);
        return resp.getData();
    }

    public ApiResponse<DynamicAdVideoAddResponse> dynamicAdVideoAddWithHttpInfo(DynamicAdVideoAddRequest data, String ... headerPair) throws ApiException {
        Call call = this.dynamicAdVideoAddValidateBeforeCall(data, null, null, headerPair);
        Type localVarReturnType = new TypeToken<DynamicAdVideoAddResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call dynamicAdVideoAddAsync(DynamicAdVideoAddRequest data, final ApiCallback<DynamicAdVideoAddResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.dynamicAdVideoAddValidateBeforeCall(data, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<DynamicAdVideoAddResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call dynamicAdVideoGetCall(Long accountId, Long productCatalogId, String productMode, String productOuterId, Long dynamicAdTemplateId, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/dynamic_ad_video/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (productCatalogId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("product_catalog_id", productCatalogId));
        }
        if (productMode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("product_mode", productMode));
        }
        if (productOuterId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("product_outer_id", productOuterId));
        }
        if (dynamicAdTemplateId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dynamic_ad_template_id", dynamicAdTemplateId));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call dynamicAdVideoGetValidateBeforeCall(Long accountId, Long productCatalogId, String productMode, String productOuterId, Long dynamicAdTemplateId, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling dynamicAdVideoGet(Async)");
        }
        if (productCatalogId == null) {
            throw new ApiException("Missing the required parameter 'productCatalogId' when calling dynamicAdVideoGet(Async)");
        }
        if (productMode == null) {
            throw new ApiException("Missing the required parameter 'productMode' when calling dynamicAdVideoGet(Async)");
        }
        if (productOuterId == null) {
            throw new ApiException("Missing the required parameter 'productOuterId' when calling dynamicAdVideoGet(Async)");
        }
        if (dynamicAdTemplateId == null) {
            throw new ApiException("Missing the required parameter 'dynamicAdTemplateId' when calling dynamicAdVideoGet(Async)");
        }
        Call call = this.dynamicAdVideoGetCall(accountId, productCatalogId, productMode, productOuterId, dynamicAdTemplateId, fields, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public DynamicAdVideoGetResponse dynamicAdVideoGet(Long accountId, Long productCatalogId, String productMode, String productOuterId, Long dynamicAdTemplateId, List<String> fields, String ... headerPair) throws ApiException {
        ApiResponse<DynamicAdVideoGetResponse> resp = this.dynamicAdVideoGetWithHttpInfo(accountId, productCatalogId, productMode, productOuterId, dynamicAdTemplateId, fields, headerPair);
        return resp.getData();
    }

    public ApiResponse<DynamicAdVideoGetResponse> dynamicAdVideoGetWithHttpInfo(Long accountId, Long productCatalogId, String productMode, String productOuterId, Long dynamicAdTemplateId, List<String> fields, String ... headerPair) throws ApiException {
        Call call = this.dynamicAdVideoGetValidateBeforeCall(accountId, productCatalogId, productMode, productOuterId, dynamicAdTemplateId, fields, null, null, headerPair);
        Type localVarReturnType = new TypeToken<DynamicAdVideoGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call dynamicAdVideoGetAsync(Long accountId, Long productCatalogId, String productMode, String productOuterId, Long dynamicAdTemplateId, List<String> fields, final ApiCallback<DynamicAdVideoGetResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.dynamicAdVideoGetValidateBeforeCall(accountId, productCatalogId, productMode, productOuterId, dynamicAdTemplateId, fields, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<DynamicAdVideoGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

