/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.VideomakerSubtitlesAddResponse;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class VideomakerSubtitlesApi {
    private ApiClient apiClient;

    public VideomakerSubtitlesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public VideomakerSubtitlesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call videomakerSubtitlesAddCall(Long accountId, String videoId, File videoFile, String signature, Boolean onlySubtitleFile, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/videomaker_subtitles/add";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accountId != null) {
            localVarFormParams.put("account_id", accountId);
        }
        if (videoId != null) {
            localVarFormParams.put("video_id", videoId);
        }
        if (videoFile != null) {
            localVarFormParams.put("video_file", videoFile);
        }
        if (signature != null) {
            localVarFormParams.put("signature", signature);
        }
        if (onlySubtitleFile != null) {
            localVarFormParams.put("only_subtitle_file", onlySubtitleFile);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call videomakerSubtitlesAddValidateBeforeCall(Long accountId, String videoId, File videoFile, String signature, Boolean onlySubtitleFile, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling videomakerSubtitlesAdd(Async)");
        }
        Call call = this.videomakerSubtitlesAddCall(accountId, videoId, videoFile, signature, onlySubtitleFile, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public VideomakerSubtitlesAddResponse videomakerSubtitlesAdd(Long accountId, String videoId, File videoFile, String signature, Boolean onlySubtitleFile, String ... headerPair) throws ApiException {
        ApiResponse<VideomakerSubtitlesAddResponse> resp = this.videomakerSubtitlesAddWithHttpInfo(accountId, videoId, videoFile, signature, onlySubtitleFile, headerPair);
        return resp.getData();
    }

    public ApiResponse<VideomakerSubtitlesAddResponse> videomakerSubtitlesAddWithHttpInfo(Long accountId, String videoId, File videoFile, String signature, Boolean onlySubtitleFile, String ... headerPair) throws ApiException {
        Call call = this.videomakerSubtitlesAddValidateBeforeCall(accountId, videoId, videoFile, signature, onlySubtitleFile, null, null, headerPair);
        Type localVarReturnType = new TypeToken<VideomakerSubtitlesAddResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call videomakerSubtitlesAddAsync(Long accountId, String videoId, File videoFile, String signature, Boolean onlySubtitleFile, final ApiCallback<VideomakerSubtitlesAddResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.videomakerSubtitlesAddValidateBeforeCall(accountId, videoId, videoFile, signature, onlySubtitleFile, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<VideomakerSubtitlesAddResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

