/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.WxPackageAccountGetResponse;
import com.tencent.ads.model.WxPackageAccountUpdateResponse;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class WxPackageAccountApi {
    private ApiClient apiClient;

    public WxPackageAccountApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WxPackageAccountApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call wxPackageAccountGetCall(Long accountId, Long pageSize, Long pageIndex, String beginTime, String endTime, String keyword, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wx_package_account/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", pageSize));
        }
        if (pageIndex != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_index", pageIndex));
        }
        if (beginTime != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("begin_time", beginTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("end_time", endTime));
        }
        if (keyword != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("keyword", keyword));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call wxPackageAccountGetValidateBeforeCall(Long accountId, Long pageSize, Long pageIndex, String beginTime, String endTime, String keyword, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling wxPackageAccountGet(Async)");
        }
        Call call = this.wxPackageAccountGetCall(accountId, pageSize, pageIndex, beginTime, endTime, keyword, fields, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public WxPackageAccountGetResponse wxPackageAccountGet(Long accountId, Long pageSize, Long pageIndex, String beginTime, String endTime, String keyword, List<String> fields, String ... headerPair) throws ApiException {
        ApiResponse<WxPackageAccountGetResponse> resp = this.wxPackageAccountGetWithHttpInfo(accountId, pageSize, pageIndex, beginTime, endTime, keyword, fields, headerPair);
        return resp.getData();
    }

    public ApiResponse<WxPackageAccountGetResponse> wxPackageAccountGetWithHttpInfo(Long accountId, Long pageSize, Long pageIndex, String beginTime, String endTime, String keyword, List<String> fields, String ... headerPair) throws ApiException {
        Call call = this.wxPackageAccountGetValidateBeforeCall(accountId, pageSize, pageIndex, beginTime, endTime, keyword, fields, null, null, headerPair);
        Type localVarReturnType = new TypeToken<WxPackageAccountGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call wxPackageAccountGetAsync(Long accountId, Long pageSize, Long pageIndex, String beginTime, String endTime, String keyword, List<String> fields, final ApiCallback<WxPackageAccountGetResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.wxPackageAccountGetValidateBeforeCall(accountId, pageSize, pageIndex, beginTime, endTime, keyword, fields, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<WxPackageAccountGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call wxPackageAccountUpdateCall(Long accountId, Long wechatId, String nickName, File file, Long enableFlag, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/wx_package_account/update";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accountId != null) {
            localVarFormParams.put("account_id", accountId);
        }
        if (wechatId != null) {
            localVarFormParams.put("wechat_id", wechatId);
        }
        if (nickName != null) {
            localVarFormParams.put("nick_name", nickName);
        }
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if (enableFlag != null) {
            localVarFormParams.put("enable_flag", enableFlag);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call wxPackageAccountUpdateValidateBeforeCall(Long accountId, Long wechatId, String nickName, File file, Long enableFlag, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling wxPackageAccountUpdate(Async)");
        }
        if (wechatId == null) {
            throw new ApiException("Missing the required parameter 'wechatId' when calling wxPackageAccountUpdate(Async)");
        }
        Call call = this.wxPackageAccountUpdateCall(accountId, wechatId, nickName, file, enableFlag, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public WxPackageAccountUpdateResponse wxPackageAccountUpdate(Long accountId, Long wechatId, String nickName, File file, Long enableFlag, String ... headerPair) throws ApiException {
        ApiResponse<WxPackageAccountUpdateResponse> resp = this.wxPackageAccountUpdateWithHttpInfo(accountId, wechatId, nickName, file, enableFlag, headerPair);
        return resp.getData();
    }

    public ApiResponse<WxPackageAccountUpdateResponse> wxPackageAccountUpdateWithHttpInfo(Long accountId, Long wechatId, String nickName, File file, Long enableFlag, String ... headerPair) throws ApiException {
        Call call = this.wxPackageAccountUpdateValidateBeforeCall(accountId, wechatId, nickName, file, enableFlag, null, null, headerPair);
        Type localVarReturnType = new TypeToken<WxPackageAccountUpdateResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call wxPackageAccountUpdateAsync(Long accountId, Long wechatId, String nickName, File file, Long enableFlag, final ApiCallback<WxPackageAccountUpdateResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.wxPackageAccountUpdateValidateBeforeCall(accountId, wechatId, nickName, file, enableFlag, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<WxPackageAccountUpdateResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

