/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.XijingTemplateListGetResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class XijingTemplateListApi {
    private ApiClient apiClient;

    public XijingTemplateListApi() {
        this(Configuration.getDefaultApiClient());
    }

    public XijingTemplateListApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call xijingTemplateListGetCall(Long accountId, String pageTemplateId, Boolean isInteraction, Boolean isPublic, String templateSource, Long pageSize, Long page, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/xijing_template_list/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (pageTemplateId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_template_id", pageTemplateId));
        }
        if (isInteraction != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("is_interaction", isInteraction));
        }
        if (isPublic != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("is_public", isPublic));
        }
        if (templateSource != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("template_source", templateSource));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", pageSize));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call xijingTemplateListGetValidateBeforeCall(Long accountId, String pageTemplateId, Boolean isInteraction, Boolean isPublic, String templateSource, Long pageSize, Long page, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling xijingTemplateListGet(Async)");
        }
        if (pageTemplateId == null) {
            throw new ApiException("Missing the required parameter 'pageTemplateId' when calling xijingTemplateListGet(Async)");
        }
        Call call = this.xijingTemplateListGetCall(accountId, pageTemplateId, isInteraction, isPublic, templateSource, pageSize, page, fields, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public XijingTemplateListGetResponse xijingTemplateListGet(Long accountId, String pageTemplateId, Boolean isInteraction, Boolean isPublic, String templateSource, Long pageSize, Long page, List<String> fields, String ... headerPair) throws ApiException {
        ApiResponse<XijingTemplateListGetResponse> resp = this.xijingTemplateListGetWithHttpInfo(accountId, pageTemplateId, isInteraction, isPublic, templateSource, pageSize, page, fields, headerPair);
        return resp.getData();
    }

    public ApiResponse<XijingTemplateListGetResponse> xijingTemplateListGetWithHttpInfo(Long accountId, String pageTemplateId, Boolean isInteraction, Boolean isPublic, String templateSource, Long pageSize, Long page, List<String> fields, String ... headerPair) throws ApiException {
        Call call = this.xijingTemplateListGetValidateBeforeCall(accountId, pageTemplateId, isInteraction, isPublic, templateSource, pageSize, page, fields, null, null, headerPair);
        Type localVarReturnType = new TypeToken<XijingTemplateListGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call xijingTemplateListGetAsync(Long accountId, String pageTemplateId, Boolean isInteraction, Boolean isPublic, String templateSource, Long pageSize, Long page, List<String> fields, final ApiCallback<XijingTemplateListGetResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.xijingTemplateListGetValidateBeforeCall(accountId, pageTemplateId, isInteraction, isPublic, templateSource, pageSize, page, fields, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<XijingTemplateListGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

