/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api.v3;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.v3.AdvertiserAddRequest;
import com.tencent.ads.model.v3.AdvertiserAddResponse;
import com.tencent.ads.model.v3.AdvertiserGetResponse;
import com.tencent.ads.model.v3.AdvertiserUpdateDailyBudgetRequest;
import com.tencent.ads.model.v3.AdvertiserUpdateDailyBudgetResponse;
import com.tencent.ads.model.v3.AdvertiserUpdateRequest;
import com.tencent.ads.model.v3.AdvertiserUpdateResponse;
import com.tencent.ads.model.v3.FilteringStruct;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AdvertiserApi {
    private ApiClient apiClient;

    public AdvertiserApi() {
        this(Configuration.getV3DefaultApiClient());
    }

    public AdvertiserApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call advertiserAddCall(AdvertiserAddRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        AdvertiserAddRequest localVarPostBody = data;
        String localVarPath = "/advertiser/add";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call advertiserAddValidateBeforeCall(AdvertiserAddRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling advertiserAdd(Async)");
        }
        Call call = this.advertiserAddCall(data, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public AdvertiserAddResponse advertiserAdd(AdvertiserAddRequest data, String ... headerPair) throws ApiException {
        ApiResponse<AdvertiserAddResponse> resp = this.advertiserAddWithHttpInfo(data, headerPair);
        return resp.getData();
    }

    public ApiResponse<AdvertiserAddResponse> advertiserAddWithHttpInfo(AdvertiserAddRequest data, String ... headerPair) throws ApiException {
        Call call = this.advertiserAddValidateBeforeCall(data, null, null, headerPair);
        Type localVarReturnType = new TypeToken<AdvertiserAddResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call advertiserAddAsync(AdvertiserAddRequest data, final ApiCallback<AdvertiserAddResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.advertiserAddValidateBeforeCall(data, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<AdvertiserAddResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call advertiserGetCall(List<String> fields, String paginationMode, Long pageSize, Long agencyId, Long accountId, List<FilteringStruct> filtering, Long page, Long cursor, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/advertiser/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (agencyId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("agency_id", agencyId));
        }
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (filtering != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "filtering", filtering));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        if (paginationMode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pagination_mode", paginationMode));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", pageSize));
        }
        if (cursor != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cursor", cursor));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call advertiserGetValidateBeforeCall(List<String> fields, String paginationMode, Long pageSize, Long agencyId, Long accountId, List<FilteringStruct> filtering, Long page, Long cursor, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (fields == null) {
            throw new ApiException("Missing the required parameter 'fields' when calling advertiserGet(Async)");
        }
        if (paginationMode == null) {
            throw new ApiException("Missing the required parameter 'paginationMode' when calling advertiserGet(Async)");
        }
        if (pageSize == null) {
            throw new ApiException("Missing the required parameter 'pageSize' when calling advertiserGet(Async)");
        }
        Call call = this.advertiserGetCall(fields, paginationMode, pageSize, agencyId, accountId, filtering, page, cursor, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public AdvertiserGetResponse advertiserGet(List<String> fields, String paginationMode, Long pageSize, Long agencyId, Long accountId, List<FilteringStruct> filtering, Long page, Long cursor, String ... headerPair) throws ApiException {
        ApiResponse<AdvertiserGetResponse> resp = this.advertiserGetWithHttpInfo(fields, paginationMode, pageSize, agencyId, accountId, filtering, page, cursor, headerPair);
        return resp.getData();
    }

    public ApiResponse<AdvertiserGetResponse> advertiserGetWithHttpInfo(List<String> fields, String paginationMode, Long pageSize, Long agencyId, Long accountId, List<FilteringStruct> filtering, Long page, Long cursor, String ... headerPair) throws ApiException {
        Call call = this.advertiserGetValidateBeforeCall(fields, paginationMode, pageSize, agencyId, accountId, filtering, page, cursor, null, null, headerPair);
        Type localVarReturnType = new TypeToken<AdvertiserGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call advertiserGetAsync(List<String> fields, String paginationMode, Long pageSize, Long agencyId, Long accountId, List<FilteringStruct> filtering, Long page, Long cursor, final ApiCallback<AdvertiserGetResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.advertiserGetValidateBeforeCall(fields, paginationMode, pageSize, agencyId, accountId, filtering, page, cursor, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<AdvertiserGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call advertiserUpdateCall(AdvertiserUpdateRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        AdvertiserUpdateRequest localVarPostBody = data;
        String localVarPath = "/advertiser/update";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call advertiserUpdateValidateBeforeCall(AdvertiserUpdateRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling advertiserUpdate(Async)");
        }
        Call call = this.advertiserUpdateCall(data, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public AdvertiserUpdateResponse advertiserUpdate(AdvertiserUpdateRequest data, String ... headerPair) throws ApiException {
        ApiResponse<AdvertiserUpdateResponse> resp = this.advertiserUpdateWithHttpInfo(data, headerPair);
        return resp.getData();
    }

    public ApiResponse<AdvertiserUpdateResponse> advertiserUpdateWithHttpInfo(AdvertiserUpdateRequest data, String ... headerPair) throws ApiException {
        Call call = this.advertiserUpdateValidateBeforeCall(data, null, null, headerPair);
        Type localVarReturnType = new TypeToken<AdvertiserUpdateResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call advertiserUpdateAsync(AdvertiserUpdateRequest data, final ApiCallback<AdvertiserUpdateResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.advertiserUpdateValidateBeforeCall(data, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<AdvertiserUpdateResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call advertiserUpdateDailyBudgetCall(AdvertiserUpdateDailyBudgetRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        AdvertiserUpdateDailyBudgetRequest localVarPostBody = data;
        String localVarPath = "/advertiser/update_daily_budget";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call advertiserUpdateDailyBudgetValidateBeforeCall(AdvertiserUpdateDailyBudgetRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling advertiserUpdateDailyBudget(Async)");
        }
        Call call = this.advertiserUpdateDailyBudgetCall(data, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public AdvertiserUpdateDailyBudgetResponse advertiserUpdateDailyBudget(AdvertiserUpdateDailyBudgetRequest data, String ... headerPair) throws ApiException {
        ApiResponse<AdvertiserUpdateDailyBudgetResponse> resp = this.advertiserUpdateDailyBudgetWithHttpInfo(data, headerPair);
        return resp.getData();
    }

    public ApiResponse<AdvertiserUpdateDailyBudgetResponse> advertiserUpdateDailyBudgetWithHttpInfo(AdvertiserUpdateDailyBudgetRequest data, String ... headerPair) throws ApiException {
        Call call = this.advertiserUpdateDailyBudgetValidateBeforeCall(data, null, null, headerPair);
        Type localVarReturnType = new TypeToken<AdvertiserUpdateDailyBudgetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call advertiserUpdateDailyBudgetAsync(AdvertiserUpdateDailyBudgetRequest data, final ApiCallback<AdvertiserUpdateDailyBudgetResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.advertiserUpdateDailyBudgetValidateBeforeCall(data, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<AdvertiserUpdateDailyBudgetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

