/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api.v3;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.v3.AgencyBusinessUnitListAccountGetResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AgencyBusinessUnitListAccountApi {
    private ApiClient apiClient;

    public AgencyBusinessUnitListAccountApi() {
        this(Configuration.getV3DefaultApiClient());
    }

    public AgencyBusinessUnitListAccountApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call agencyBusinessUnitListAccountGetCall(Long organizationId, Long page, Long pageSize, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/agency_business_unit_list_account/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (organizationId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("organization_id", organizationId));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call agencyBusinessUnitListAccountGetValidateBeforeCall(Long organizationId, Long page, Long pageSize, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (organizationId == null) {
            throw new ApiException("Missing the required parameter 'organizationId' when calling agencyBusinessUnitListAccountGet(Async)");
        }
        if (page == null) {
            throw new ApiException("Missing the required parameter 'page' when calling agencyBusinessUnitListAccountGet(Async)");
        }
        if (pageSize == null) {
            throw new ApiException("Missing the required parameter 'pageSize' when calling agencyBusinessUnitListAccountGet(Async)");
        }
        Call call = this.agencyBusinessUnitListAccountGetCall(organizationId, page, pageSize, fields, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public AgencyBusinessUnitListAccountGetResponse agencyBusinessUnitListAccountGet(Long organizationId, Long page, Long pageSize, List<String> fields, String ... headerPair) throws ApiException {
        ApiResponse<AgencyBusinessUnitListAccountGetResponse> resp = this.agencyBusinessUnitListAccountGetWithHttpInfo(organizationId, page, pageSize, fields, headerPair);
        return resp.getData();
    }

    public ApiResponse<AgencyBusinessUnitListAccountGetResponse> agencyBusinessUnitListAccountGetWithHttpInfo(Long organizationId, Long page, Long pageSize, List<String> fields, String ... headerPair) throws ApiException {
        Call call = this.agencyBusinessUnitListAccountGetValidateBeforeCall(organizationId, page, pageSize, fields, null, null, headerPair);
        Type localVarReturnType = new TypeToken<AgencyBusinessUnitListAccountGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call agencyBusinessUnitListAccountGetAsync(Long organizationId, Long page, Long pageSize, List<String> fields, final ApiCallback<AgencyBusinessUnitListAccountGetResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.agencyBusinessUnitListAccountGetValidateBeforeCall(organizationId, page, pageSize, fields, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<AgencyBusinessUnitListAccountGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

