/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api.v3;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.v3.ComponentElementUrgeReviewAddRequest;
import com.tencent.ads.model.v3.ComponentElementUrgeReviewAddResponse;
import com.tencent.ads.model.v3.ComponentElementUrgeReviewGetResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ComponentElementUrgeReviewApi {
    private ApiClient apiClient;

    public ComponentElementUrgeReviewApi() {
        this(Configuration.getV3DefaultApiClient());
    }

    public ComponentElementUrgeReviewApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call componentElementUrgeReviewAddCall(ComponentElementUrgeReviewAddRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        ComponentElementUrgeReviewAddRequest localVarPostBody = data;
        String localVarPath = "/component_element_urge_review/add";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call componentElementUrgeReviewAddValidateBeforeCall(ComponentElementUrgeReviewAddRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling componentElementUrgeReviewAdd(Async)");
        }
        Call call = this.componentElementUrgeReviewAddCall(data, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public ComponentElementUrgeReviewAddResponse componentElementUrgeReviewAdd(ComponentElementUrgeReviewAddRequest data, String ... headerPair) throws ApiException {
        ApiResponse<ComponentElementUrgeReviewAddResponse> resp = this.componentElementUrgeReviewAddWithHttpInfo(data, headerPair);
        return resp.getData();
    }

    public ApiResponse<ComponentElementUrgeReviewAddResponse> componentElementUrgeReviewAddWithHttpInfo(ComponentElementUrgeReviewAddRequest data, String ... headerPair) throws ApiException {
        Call call = this.componentElementUrgeReviewAddValidateBeforeCall(data, null, null, headerPair);
        Type localVarReturnType = new TypeToken<ComponentElementUrgeReviewAddResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call componentElementUrgeReviewAddAsync(ComponentElementUrgeReviewAddRequest data, final ApiCallback<ComponentElementUrgeReviewAddResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.componentElementUrgeReviewAddValidateBeforeCall(data, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<ComponentElementUrgeReviewAddResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call componentElementUrgeReviewGetCall(Long accountId, Long dynamicCreativeId, List<Long> componentIdList, List<String> elementFingerprintList, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/component_element_urge_review/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (dynamicCreativeId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dynamic_creative_id", dynamicCreativeId));
        }
        if (componentIdList != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "component_id_list", componentIdList));
        }
        if (elementFingerprintList != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "element_fingerprint_list", elementFingerprintList));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call componentElementUrgeReviewGetValidateBeforeCall(Long accountId, Long dynamicCreativeId, List<Long> componentIdList, List<String> elementFingerprintList, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling componentElementUrgeReviewGet(Async)");
        }
        if (dynamicCreativeId == null) {
            throw new ApiException("Missing the required parameter 'dynamicCreativeId' when calling componentElementUrgeReviewGet(Async)");
        }
        Call call = this.componentElementUrgeReviewGetCall(accountId, dynamicCreativeId, componentIdList, elementFingerprintList, fields, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public ComponentElementUrgeReviewGetResponse componentElementUrgeReviewGet(Long accountId, Long dynamicCreativeId, List<Long> componentIdList, List<String> elementFingerprintList, List<String> fields, String ... headerPair) throws ApiException {
        ApiResponse<ComponentElementUrgeReviewGetResponse> resp = this.componentElementUrgeReviewGetWithHttpInfo(accountId, dynamicCreativeId, componentIdList, elementFingerprintList, fields, headerPair);
        return resp.getData();
    }

    public ApiResponse<ComponentElementUrgeReviewGetResponse> componentElementUrgeReviewGetWithHttpInfo(Long accountId, Long dynamicCreativeId, List<Long> componentIdList, List<String> elementFingerprintList, List<String> fields, String ... headerPair) throws ApiException {
        Call call = this.componentElementUrgeReviewGetValidateBeforeCall(accountId, dynamicCreativeId, componentIdList, elementFingerprintList, fields, null, null, headerPair);
        Type localVarReturnType = new TypeToken<ComponentElementUrgeReviewGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call componentElementUrgeReviewGetAsync(Long accountId, Long dynamicCreativeId, List<Long> componentIdList, List<String> elementFingerprintList, List<String> fields, final ApiCallback<ComponentElementUrgeReviewGetResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.componentElementUrgeReviewGetValidateBeforeCall(accountId, dynamicCreativeId, componentIdList, elementFingerprintList, fields, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<ComponentElementUrgeReviewGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

