/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api.v3;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.v3.CreativeTemplateGetResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CreativeTemplateApi {
    private ApiClient apiClient;

    public CreativeTemplateApi() {
        this(Configuration.getV3DefaultApiClient());
    }

    public CreativeTemplateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call creativeTemplateGetCall(Long accountId, String marketingGoal, String marketingTargetType, String marketingCarrierType, String deliveryMode, String marketingSubGoal, Boolean automaticSiteEnabled, List<String> siteSet, String dynamicCreativeType, Long creativeTemplateId, Long conversionLinkAssetId, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/creative_template/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (marketingGoal != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketing_goal", marketingGoal));
        }
        if (marketingSubGoal != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketing_sub_goal", marketingSubGoal));
        }
        if (marketingTargetType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketing_target_type", marketingTargetType));
        }
        if (marketingCarrierType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketing_carrier_type", marketingCarrierType));
        }
        if (automaticSiteEnabled != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("automatic_site_enabled", automaticSiteEnabled));
        }
        if (siteSet != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "site_set", siteSet));
        }
        if (deliveryMode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("delivery_mode", deliveryMode));
        }
        if (dynamicCreativeType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dynamic_creative_type", dynamicCreativeType));
        }
        if (creativeTemplateId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("creative_template_id", creativeTemplateId));
        }
        if (conversionLinkAssetId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("conversion_link_asset_id", conversionLinkAssetId));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call creativeTemplateGetValidateBeforeCall(Long accountId, String marketingGoal, String marketingTargetType, String marketingCarrierType, String deliveryMode, String marketingSubGoal, Boolean automaticSiteEnabled, List<String> siteSet, String dynamicCreativeType, Long creativeTemplateId, Long conversionLinkAssetId, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling creativeTemplateGet(Async)");
        }
        if (marketingGoal == null) {
            throw new ApiException("Missing the required parameter 'marketingGoal' when calling creativeTemplateGet(Async)");
        }
        if (marketingTargetType == null) {
            throw new ApiException("Missing the required parameter 'marketingTargetType' when calling creativeTemplateGet(Async)");
        }
        if (marketingCarrierType == null) {
            throw new ApiException("Missing the required parameter 'marketingCarrierType' when calling creativeTemplateGet(Async)");
        }
        if (deliveryMode == null) {
            throw new ApiException("Missing the required parameter 'deliveryMode' when calling creativeTemplateGet(Async)");
        }
        Call call = this.creativeTemplateGetCall(accountId, marketingGoal, marketingTargetType, marketingCarrierType, deliveryMode, marketingSubGoal, automaticSiteEnabled, siteSet, dynamicCreativeType, creativeTemplateId, conversionLinkAssetId, fields, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public CreativeTemplateGetResponse creativeTemplateGet(Long accountId, String marketingGoal, String marketingTargetType, String marketingCarrierType, String deliveryMode, String marketingSubGoal, Boolean automaticSiteEnabled, List<String> siteSet, String dynamicCreativeType, Long creativeTemplateId, Long conversionLinkAssetId, List<String> fields, String ... headerPair) throws ApiException {
        ApiResponse<CreativeTemplateGetResponse> resp = this.creativeTemplateGetWithHttpInfo(accountId, marketingGoal, marketingTargetType, marketingCarrierType, deliveryMode, marketingSubGoal, automaticSiteEnabled, siteSet, dynamicCreativeType, creativeTemplateId, conversionLinkAssetId, fields, headerPair);
        return resp.getData();
    }

    public ApiResponse<CreativeTemplateGetResponse> creativeTemplateGetWithHttpInfo(Long accountId, String marketingGoal, String marketingTargetType, String marketingCarrierType, String deliveryMode, String marketingSubGoal, Boolean automaticSiteEnabled, List<String> siteSet, String dynamicCreativeType, Long creativeTemplateId, Long conversionLinkAssetId, List<String> fields, String ... headerPair) throws ApiException {
        Call call = this.creativeTemplateGetValidateBeforeCall(accountId, marketingGoal, marketingTargetType, marketingCarrierType, deliveryMode, marketingSubGoal, automaticSiteEnabled, siteSet, dynamicCreativeType, creativeTemplateId, conversionLinkAssetId, fields, null, null, headerPair);
        Type localVarReturnType = new TypeToken<CreativeTemplateGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call creativeTemplateGetAsync(Long accountId, String marketingGoal, String marketingTargetType, String marketingCarrierType, String deliveryMode, String marketingSubGoal, Boolean automaticSiteEnabled, List<String> siteSet, String dynamicCreativeType, Long creativeTemplateId, Long conversionLinkAssetId, List<String> fields, final ApiCallback<CreativeTemplateGetResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.creativeTemplateGetValidateBeforeCall(accountId, marketingGoal, marketingTargetType, marketingCarrierType, deliveryMode, marketingSubGoal, automaticSiteEnabled, siteSet, dynamicCreativeType, creativeTemplateId, conversionLinkAssetId, fields, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<CreativeTemplateGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

