/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api.v3;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.v3.CreativeTemplateListGetResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CreativeTemplateListApi {
    private ApiClient apiClient;

    public CreativeTemplateListApi() {
        this(Configuration.getV3DefaultApiClient());
    }

    public CreativeTemplateListApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call creativeTemplateListGetCall(Long accountId, String marketingGoal, String marketingTargetType, String marketingCarrierType, String marketingSubGoal, String siteSet, String dynamicAbilityType, List<Long> wechatSceneSpecPosition, Long creativeTemplateId, Long page, Long pageSize, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/creative_template_list/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (marketingGoal != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketing_goal", marketingGoal));
        }
        if (marketingSubGoal != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketing_sub_goal", marketingSubGoal));
        }
        if (marketingTargetType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketing_target_type", marketingTargetType));
        }
        if (marketingCarrierType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketing_carrier_type", marketingCarrierType));
        }
        if (siteSet != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("site_set", siteSet));
        }
        if (dynamicAbilityType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dynamic_ability_type", dynamicAbilityType));
        }
        if (wechatSceneSpecPosition != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "wechat_scene_spec_position", wechatSceneSpecPosition));
        }
        if (creativeTemplateId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("creative_template_id", creativeTemplateId));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call creativeTemplateListGetValidateBeforeCall(Long accountId, String marketingGoal, String marketingTargetType, String marketingCarrierType, String marketingSubGoal, String siteSet, String dynamicAbilityType, List<Long> wechatSceneSpecPosition, Long creativeTemplateId, Long page, Long pageSize, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling creativeTemplateListGet(Async)");
        }
        if (marketingGoal == null) {
            throw new ApiException("Missing the required parameter 'marketingGoal' when calling creativeTemplateListGet(Async)");
        }
        if (marketingTargetType == null) {
            throw new ApiException("Missing the required parameter 'marketingTargetType' when calling creativeTemplateListGet(Async)");
        }
        if (marketingCarrierType == null) {
            throw new ApiException("Missing the required parameter 'marketingCarrierType' when calling creativeTemplateListGet(Async)");
        }
        Call call = this.creativeTemplateListGetCall(accountId, marketingGoal, marketingTargetType, marketingCarrierType, marketingSubGoal, siteSet, dynamicAbilityType, wechatSceneSpecPosition, creativeTemplateId, page, pageSize, fields, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public CreativeTemplateListGetResponse creativeTemplateListGet(Long accountId, String marketingGoal, String marketingTargetType, String marketingCarrierType, String marketingSubGoal, String siteSet, String dynamicAbilityType, List<Long> wechatSceneSpecPosition, Long creativeTemplateId, Long page, Long pageSize, List<String> fields, String ... headerPair) throws ApiException {
        ApiResponse<CreativeTemplateListGetResponse> resp = this.creativeTemplateListGetWithHttpInfo(accountId, marketingGoal, marketingTargetType, marketingCarrierType, marketingSubGoal, siteSet, dynamicAbilityType, wechatSceneSpecPosition, creativeTemplateId, page, pageSize, fields, headerPair);
        return resp.getData();
    }

    public ApiResponse<CreativeTemplateListGetResponse> creativeTemplateListGetWithHttpInfo(Long accountId, String marketingGoal, String marketingTargetType, String marketingCarrierType, String marketingSubGoal, String siteSet, String dynamicAbilityType, List<Long> wechatSceneSpecPosition, Long creativeTemplateId, Long page, Long pageSize, List<String> fields, String ... headerPair) throws ApiException {
        Call call = this.creativeTemplateListGetValidateBeforeCall(accountId, marketingGoal, marketingTargetType, marketingCarrierType, marketingSubGoal, siteSet, dynamicAbilityType, wechatSceneSpecPosition, creativeTemplateId, page, pageSize, fields, null, null, headerPair);
        Type localVarReturnType = new TypeToken<CreativeTemplateListGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call creativeTemplateListGetAsync(Long accountId, String marketingGoal, String marketingTargetType, String marketingCarrierType, String marketingSubGoal, String siteSet, String dynamicAbilityType, List<Long> wechatSceneSpecPosition, Long creativeTemplateId, Long page, Long pageSize, List<String> fields, final ApiCallback<CreativeTemplateListGetResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.creativeTemplateListGetValidateBeforeCall(accountId, marketingGoal, marketingTargetType, marketingCarrierType, marketingSubGoal, siteSet, dynamicAbilityType, wechatSceneSpecPosition, creativeTemplateId, page, pageSize, fields, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<CreativeTemplateListGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

