/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api.v3;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.v3.DataSourceDispatchGetResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DataSourceDispatchApi {
    private ApiClient apiClient;

    public DataSourceDispatchApi() {
        this(Configuration.getV3DefaultApiClient());
    }

    public DataSourceDispatchApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call dataSourceDispatchGetCall(Long accountId, Long userActionSetId, String type, String name, List<String> scenes, String switchType, String accessWay, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/data_source_dispatch/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (userActionSetId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("user_action_set_id", userActionSetId));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        }
        if (scenes != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "scenes", scenes));
        }
        if (switchType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("switch_type", switchType));
        }
        if (accessWay != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("access_way", accessWay));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call dataSourceDispatchGetValidateBeforeCall(Long accountId, Long userActionSetId, String type, String name, List<String> scenes, String switchType, String accessWay, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling dataSourceDispatchGet(Async)");
        }
        Call call = this.dataSourceDispatchGetCall(accountId, userActionSetId, type, name, scenes, switchType, accessWay, fields, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public DataSourceDispatchGetResponse dataSourceDispatchGet(Long accountId, Long userActionSetId, String type, String name, List<String> scenes, String switchType, String accessWay, List<String> fields, String ... headerPair) throws ApiException {
        ApiResponse<DataSourceDispatchGetResponse> resp = this.dataSourceDispatchGetWithHttpInfo(accountId, userActionSetId, type, name, scenes, switchType, accessWay, fields, headerPair);
        return resp.getData();
    }

    public ApiResponse<DataSourceDispatchGetResponse> dataSourceDispatchGetWithHttpInfo(Long accountId, Long userActionSetId, String type, String name, List<String> scenes, String switchType, String accessWay, List<String> fields, String ... headerPair) throws ApiException {
        Call call = this.dataSourceDispatchGetValidateBeforeCall(accountId, userActionSetId, type, name, scenes, switchType, accessWay, fields, null, null, headerPair);
        Type localVarReturnType = new TypeToken<DataSourceDispatchGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call dataSourceDispatchGetAsync(Long accountId, Long userActionSetId, String type, String name, List<String> scenes, String switchType, String accessWay, List<String> fields, final ApiCallback<DataSourceDispatchGetResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.dataSourceDispatchGetValidateBeforeCall(accountId, userActionSetId, type, name, scenes, switchType, accessWay, fields, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<DataSourceDispatchGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

