/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api.v3;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.v3.DateRange;
import com.tencent.ads.model.v3.EcommerceOrderGetResponse;
import com.tencent.ads.model.v3.EcommerceOrderUpdateRequest;
import com.tencent.ads.model.v3.EcommerceOrderUpdateResponse;
import com.tencent.ads.model.v3.FilteringStruct;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class EcommerceOrderApi {
    private ApiClient apiClient;

    public EcommerceOrderApi() {
        this(Configuration.getV3DefaultApiClient());
    }

    public EcommerceOrderApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call ecommerceOrderGetCall(Long accountId, DateRange dateRange, List<FilteringStruct> filtering, String date, Long page, Long pageSize, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/ecommerce_order/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (filtering != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "filtering", filtering));
        }
        if (date != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("date", date));
        }
        if (dateRange != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("date_range", dateRange));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call ecommerceOrderGetValidateBeforeCall(Long accountId, DateRange dateRange, List<FilteringStruct> filtering, String date, Long page, Long pageSize, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling ecommerceOrderGet(Async)");
        }
        if (dateRange == null) {
            throw new ApiException("Missing the required parameter 'dateRange' when calling ecommerceOrderGet(Async)");
        }
        Call call = this.ecommerceOrderGetCall(accountId, dateRange, filtering, date, page, pageSize, fields, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public EcommerceOrderGetResponse ecommerceOrderGet(Long accountId, DateRange dateRange, List<FilteringStruct> filtering, String date, Long page, Long pageSize, List<String> fields, String ... headerPair) throws ApiException {
        ApiResponse<EcommerceOrderGetResponse> resp = this.ecommerceOrderGetWithHttpInfo(accountId, dateRange, filtering, date, page, pageSize, fields, headerPair);
        return resp.getData();
    }

    public ApiResponse<EcommerceOrderGetResponse> ecommerceOrderGetWithHttpInfo(Long accountId, DateRange dateRange, List<FilteringStruct> filtering, String date, Long page, Long pageSize, List<String> fields, String ... headerPair) throws ApiException {
        Call call = this.ecommerceOrderGetValidateBeforeCall(accountId, dateRange, filtering, date, page, pageSize, fields, null, null, headerPair);
        Type localVarReturnType = new TypeToken<EcommerceOrderGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call ecommerceOrderGetAsync(Long accountId, DateRange dateRange, List<FilteringStruct> filtering, String date, Long page, Long pageSize, List<String> fields, final ApiCallback<EcommerceOrderGetResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.ecommerceOrderGetValidateBeforeCall(accountId, dateRange, filtering, date, page, pageSize, fields, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<EcommerceOrderGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call ecommerceOrderUpdateCall(EcommerceOrderUpdateRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        EcommerceOrderUpdateRequest localVarPostBody = data;
        String localVarPath = "/ecommerce_order/update";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call ecommerceOrderUpdateValidateBeforeCall(EcommerceOrderUpdateRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling ecommerceOrderUpdate(Async)");
        }
        Call call = this.ecommerceOrderUpdateCall(data, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public EcommerceOrderUpdateResponse ecommerceOrderUpdate(EcommerceOrderUpdateRequest data, String ... headerPair) throws ApiException {
        ApiResponse<EcommerceOrderUpdateResponse> resp = this.ecommerceOrderUpdateWithHttpInfo(data, headerPair);
        return resp.getData();
    }

    public ApiResponse<EcommerceOrderUpdateResponse> ecommerceOrderUpdateWithHttpInfo(EcommerceOrderUpdateRequest data, String ... headerPair) throws ApiException {
        Call call = this.ecommerceOrderUpdateValidateBeforeCall(data, null, null, headerPair);
        Type localVarReturnType = new TypeToken<EcommerceOrderUpdateResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call ecommerceOrderUpdateAsync(EcommerceOrderUpdateRequest data, final ApiCallback<EcommerceOrderUpdateResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.ecommerceOrderUpdateValidateBeforeCall(data, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<EcommerceOrderUpdateResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

