/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api.v3;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.v3.GameFeatureAddRequest;
import com.tencent.ads.model.v3.GameFeatureAddResponse;
import com.tencent.ads.model.v3.GameFeatureGetResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GameFeatureApi {
    private ApiClient apiClient;

    public GameFeatureApi() {
        this(Configuration.getV3DefaultApiClient());
    }

    public GameFeatureApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call gameFeatureAddCall(GameFeatureAddRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        GameFeatureAddRequest localVarPostBody = data;
        String localVarPath = "/game_feature/add";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call gameFeatureAddValidateBeforeCall(GameFeatureAddRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling gameFeatureAdd(Async)");
        }
        Call call = this.gameFeatureAddCall(data, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public GameFeatureAddResponse gameFeatureAdd(GameFeatureAddRequest data, String ... headerPair) throws ApiException {
        ApiResponse<GameFeatureAddResponse> resp = this.gameFeatureAddWithHttpInfo(data, headerPair);
        return resp.getData();
    }

    public ApiResponse<GameFeatureAddResponse> gameFeatureAddWithHttpInfo(GameFeatureAddRequest data, String ... headerPair) throws ApiException {
        Call call = this.gameFeatureAddValidateBeforeCall(data, null, null, headerPair);
        Type localVarReturnType = new TypeToken<GameFeatureAddResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call gameFeatureAddAsync(GameFeatureAddRequest data, final ApiCallback<GameFeatureAddResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.gameFeatureAddValidateBeforeCall(data, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<GameFeatureAddResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call gameFeatureGetCall(Long accountId, String marketingTargetType, String marketingTargetDetailId, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/game_feature/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (marketingTargetType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketing_target_type", marketingTargetType));
        }
        if (marketingTargetDetailId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketing_target_detail_id", marketingTargetDetailId));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call gameFeatureGetValidateBeforeCall(Long accountId, String marketingTargetType, String marketingTargetDetailId, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling gameFeatureGet(Async)");
        }
        if (marketingTargetType == null) {
            throw new ApiException("Missing the required parameter 'marketingTargetType' when calling gameFeatureGet(Async)");
        }
        if (marketingTargetDetailId == null) {
            throw new ApiException("Missing the required parameter 'marketingTargetDetailId' when calling gameFeatureGet(Async)");
        }
        Call call = this.gameFeatureGetCall(accountId, marketingTargetType, marketingTargetDetailId, fields, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public GameFeatureGetResponse gameFeatureGet(Long accountId, String marketingTargetType, String marketingTargetDetailId, List<String> fields, String ... headerPair) throws ApiException {
        ApiResponse<GameFeatureGetResponse> resp = this.gameFeatureGetWithHttpInfo(accountId, marketingTargetType, marketingTargetDetailId, fields, headerPair);
        return resp.getData();
    }

    public ApiResponse<GameFeatureGetResponse> gameFeatureGetWithHttpInfo(Long accountId, String marketingTargetType, String marketingTargetDetailId, List<String> fields, String ... headerPair) throws ApiException {
        Call call = this.gameFeatureGetValidateBeforeCall(accountId, marketingTargetType, marketingTargetDetailId, fields, null, null, headerPair);
        Type localVarReturnType = new TypeToken<GameFeatureGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call gameFeatureGetAsync(Long accountId, String marketingTargetType, String marketingTargetDetailId, List<String> fields, final ApiCallback<GameFeatureGetResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.gameFeatureGetValidateBeforeCall(accountId, marketingTargetType, marketingTargetDetailId, fields, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<GameFeatureGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

