/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api.v3;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.v3.FilteringStruct;
import com.tencent.ads.model.v3.ImagesAddResponse;
import com.tencent.ads.model.v3.ImagesDeleteRequest;
import com.tencent.ads.model.v3.ImagesDeleteResponse;
import com.tencent.ads.model.v3.ImagesGetResponse;
import com.tencent.ads.model.v3.ImagesUpdateRequest;
import com.tencent.ads.model.v3.ImagesUpdateResponse;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ImagesApi {
    private ApiClient apiClient;

    public ImagesApi() {
        this(Configuration.getV3DefaultApiClient());
    }

    public ImagesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call imagesAddCall(Long accountId, String uploadType, String signature, File file, String bytes, String imageUsage, String description, Long resizeWidth, Long resizeHeight, Long resizeFileSize, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/images/add";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accountId != null) {
            localVarFormParams.put("account_id", accountId);
        }
        if (uploadType != null) {
            localVarFormParams.put("upload_type", uploadType);
        }
        if (signature != null) {
            localVarFormParams.put("signature", signature);
        }
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if (bytes != null) {
            localVarFormParams.put("bytes", bytes);
        }
        if (imageUsage != null) {
            localVarFormParams.put("image_usage", imageUsage);
        }
        if (description != null) {
            localVarFormParams.put("description", description);
        }
        if (resizeWidth != null) {
            localVarFormParams.put("resize_width", resizeWidth);
        }
        if (resizeHeight != null) {
            localVarFormParams.put("resize_height", resizeHeight);
        }
        if (resizeFileSize != null) {
            localVarFormParams.put("resize_file_size", resizeFileSize);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call imagesAddValidateBeforeCall(Long accountId, String uploadType, String signature, File file, String bytes, String imageUsage, String description, Long resizeWidth, Long resizeHeight, Long resizeFileSize, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling imagesAdd(Async)");
        }
        if (uploadType == null) {
            throw new ApiException("Missing the required parameter 'uploadType' when calling imagesAdd(Async)");
        }
        if (signature == null) {
            throw new ApiException("Missing the required parameter 'signature' when calling imagesAdd(Async)");
        }
        Call call = this.imagesAddCall(accountId, uploadType, signature, file, bytes, imageUsage, description, resizeWidth, resizeHeight, resizeFileSize, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public ImagesAddResponse imagesAdd(Long accountId, String uploadType, String signature, File file, String bytes, String imageUsage, String description, Long resizeWidth, Long resizeHeight, Long resizeFileSize, String ... headerPair) throws ApiException {
        ApiResponse<ImagesAddResponse> resp = this.imagesAddWithHttpInfo(accountId, uploadType, signature, file, bytes, imageUsage, description, resizeWidth, resizeHeight, resizeFileSize, headerPair);
        return resp.getData();
    }

    public ApiResponse<ImagesAddResponse> imagesAddWithHttpInfo(Long accountId, String uploadType, String signature, File file, String bytes, String imageUsage, String description, Long resizeWidth, Long resizeHeight, Long resizeFileSize, String ... headerPair) throws ApiException {
        Call call = this.imagesAddValidateBeforeCall(accountId, uploadType, signature, file, bytes, imageUsage, description, resizeWidth, resizeHeight, resizeFileSize, null, null, headerPair);
        Type localVarReturnType = new TypeToken<ImagesAddResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call imagesAddAsync(Long accountId, String uploadType, String signature, File file, String bytes, String imageUsage, String description, Long resizeWidth, Long resizeHeight, Long resizeFileSize, final ApiCallback<ImagesAddResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.imagesAddValidateBeforeCall(accountId, uploadType, signature, file, bytes, imageUsage, description, resizeWidth, resizeHeight, resizeFileSize, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<ImagesAddResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call imagesDeleteCall(ImagesDeleteRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        ImagesDeleteRequest localVarPostBody = data;
        String localVarPath = "/images/delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call imagesDeleteValidateBeforeCall(ImagesDeleteRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling imagesDelete(Async)");
        }
        Call call = this.imagesDeleteCall(data, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public ImagesDeleteResponse imagesDelete(ImagesDeleteRequest data, String ... headerPair) throws ApiException {
        ApiResponse<ImagesDeleteResponse> resp = this.imagesDeleteWithHttpInfo(data, headerPair);
        return resp.getData();
    }

    public ApiResponse<ImagesDeleteResponse> imagesDeleteWithHttpInfo(ImagesDeleteRequest data, String ... headerPair) throws ApiException {
        Call call = this.imagesDeleteValidateBeforeCall(data, null, null, headerPair);
        Type localVarReturnType = new TypeToken<ImagesDeleteResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call imagesDeleteAsync(ImagesDeleteRequest data, final ApiCallback<ImagesDeleteResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.imagesDeleteValidateBeforeCall(data, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<ImagesDeleteResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call imagesGetCall(Long accountId, List<FilteringStruct> filtering, Long page, Long pageSize, Long labelId, Long businessScenario, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/images/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (filtering != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "filtering", filtering));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", pageSize));
        }
        if (labelId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("label_id", labelId));
        }
        if (businessScenario != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("business_scenario", businessScenario));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call imagesGetValidateBeforeCall(Long accountId, List<FilteringStruct> filtering, Long page, Long pageSize, Long labelId, Long businessScenario, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling imagesGet(Async)");
        }
        Call call = this.imagesGetCall(accountId, filtering, page, pageSize, labelId, businessScenario, fields, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public ImagesGetResponse imagesGet(Long accountId, List<FilteringStruct> filtering, Long page, Long pageSize, Long labelId, Long businessScenario, List<String> fields, String ... headerPair) throws ApiException {
        ApiResponse<ImagesGetResponse> resp = this.imagesGetWithHttpInfo(accountId, filtering, page, pageSize, labelId, businessScenario, fields, headerPair);
        return resp.getData();
    }

    public ApiResponse<ImagesGetResponse> imagesGetWithHttpInfo(Long accountId, List<FilteringStruct> filtering, Long page, Long pageSize, Long labelId, Long businessScenario, List<String> fields, String ... headerPair) throws ApiException {
        Call call = this.imagesGetValidateBeforeCall(accountId, filtering, page, pageSize, labelId, businessScenario, fields, null, null, headerPair);
        Type localVarReturnType = new TypeToken<ImagesGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call imagesGetAsync(Long accountId, List<FilteringStruct> filtering, Long page, Long pageSize, Long labelId, Long businessScenario, List<String> fields, final ApiCallback<ImagesGetResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.imagesGetValidateBeforeCall(accountId, filtering, page, pageSize, labelId, businessScenario, fields, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<ImagesGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call imagesUpdateCall(ImagesUpdateRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        ImagesUpdateRequest localVarPostBody = data;
        String localVarPath = "/images/update";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call imagesUpdateValidateBeforeCall(ImagesUpdateRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling imagesUpdate(Async)");
        }
        Call call = this.imagesUpdateCall(data, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public ImagesUpdateResponse imagesUpdate(ImagesUpdateRequest data, String ... headerPair) throws ApiException {
        ApiResponse<ImagesUpdateResponse> resp = this.imagesUpdateWithHttpInfo(data, headerPair);
        return resp.getData();
    }

    public ApiResponse<ImagesUpdateResponse> imagesUpdateWithHttpInfo(ImagesUpdateRequest data, String ... headerPair) throws ApiException {
        Call call = this.imagesUpdateValidateBeforeCall(data, null, null, headerPair);
        Type localVarReturnType = new TypeToken<ImagesUpdateResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call imagesUpdateAsync(ImagesUpdateRequest data, final ApiCallback<ImagesUpdateResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.imagesUpdateValidateBeforeCall(data, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<ImagesUpdateResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

