/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api.v3;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.v3.KeywordRecommendGetResponse;
import com.tencent.ads.model.v3.OrderByStructInfo;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class KeywordRecommendApi {
    private ApiClient apiClient;

    public KeywordRecommendApi() {
        this(Configuration.getV3DefaultApiClient());
    }

    public KeywordRecommendApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call keywordRecommendGetCall(List<String> siteSets, String recommendCategory, Long accountId, Long systemIndustryId, List<String> queryWord, String businessPointId, Long adgroupId, Long campaignId, List<String> includeWord, List<String> excludeWord, Boolean filterAdWord, Boolean filterAccountWord, List<String> recommendReasons, List<Long> province, List<Long> city, List<OrderByStructInfo> orderBy, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/keyword_recommend/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (siteSets != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "site_sets", siteSets));
        }
        if (recommendCategory != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("recommend_category", recommendCategory));
        }
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (systemIndustryId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("system_industry_id", systemIndustryId));
        }
        if (queryWord != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "query_word", queryWord));
        }
        if (businessPointId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("business_point_id", businessPointId));
        }
        if (adgroupId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("adgroup_id", adgroupId));
        }
        if (campaignId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("campaign_id", campaignId));
        }
        if (includeWord != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "include_word", includeWord));
        }
        if (excludeWord != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "exclude_word", excludeWord));
        }
        if (filterAdWord != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("filter_ad_word", filterAdWord));
        }
        if (filterAccountWord != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("filter_account_word", filterAccountWord));
        }
        if (recommendReasons != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "recommend_reasons", recommendReasons));
        }
        if (province != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "province", province));
        }
        if (city != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "city", city));
        }
        if (orderBy != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "order_by", orderBy));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call keywordRecommendGetValidateBeforeCall(List<String> siteSets, String recommendCategory, Long accountId, Long systemIndustryId, List<String> queryWord, String businessPointId, Long adgroupId, Long campaignId, List<String> includeWord, List<String> excludeWord, Boolean filterAdWord, Boolean filterAccountWord, List<String> recommendReasons, List<Long> province, List<Long> city, List<OrderByStructInfo> orderBy, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (siteSets == null) {
            throw new ApiException("Missing the required parameter 'siteSets' when calling keywordRecommendGet(Async)");
        }
        if (recommendCategory == null) {
            throw new ApiException("Missing the required parameter 'recommendCategory' when calling keywordRecommendGet(Async)");
        }
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling keywordRecommendGet(Async)");
        }
        if (systemIndustryId == null) {
            throw new ApiException("Missing the required parameter 'systemIndustryId' when calling keywordRecommendGet(Async)");
        }
        Call call = this.keywordRecommendGetCall(siteSets, recommendCategory, accountId, systemIndustryId, queryWord, businessPointId, adgroupId, campaignId, includeWord, excludeWord, filterAdWord, filterAccountWord, recommendReasons, province, city, orderBy, fields, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public KeywordRecommendGetResponse keywordRecommendGet(List<String> siteSets, String recommendCategory, Long accountId, Long systemIndustryId, List<String> queryWord, String businessPointId, Long adgroupId, Long campaignId, List<String> includeWord, List<String> excludeWord, Boolean filterAdWord, Boolean filterAccountWord, List<String> recommendReasons, List<Long> province, List<Long> city, List<OrderByStructInfo> orderBy, List<String> fields, String ... headerPair) throws ApiException {
        ApiResponse<KeywordRecommendGetResponse> resp = this.keywordRecommendGetWithHttpInfo(siteSets, recommendCategory, accountId, systemIndustryId, queryWord, businessPointId, adgroupId, campaignId, includeWord, excludeWord, filterAdWord, filterAccountWord, recommendReasons, province, city, orderBy, fields, headerPair);
        return resp.getData();
    }

    public ApiResponse<KeywordRecommendGetResponse> keywordRecommendGetWithHttpInfo(List<String> siteSets, String recommendCategory, Long accountId, Long systemIndustryId, List<String> queryWord, String businessPointId, Long adgroupId, Long campaignId, List<String> includeWord, List<String> excludeWord, Boolean filterAdWord, Boolean filterAccountWord, List<String> recommendReasons, List<Long> province, List<Long> city, List<OrderByStructInfo> orderBy, List<String> fields, String ... headerPair) throws ApiException {
        Call call = this.keywordRecommendGetValidateBeforeCall(siteSets, recommendCategory, accountId, systemIndustryId, queryWord, businessPointId, adgroupId, campaignId, includeWord, excludeWord, filterAdWord, filterAccountWord, recommendReasons, province, city, orderBy, fields, null, null, headerPair);
        Type localVarReturnType = new TypeToken<KeywordRecommendGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call keywordRecommendGetAsync(List<String> siteSets, String recommendCategory, Long accountId, Long systemIndustryId, List<String> queryWord, String businessPointId, Long adgroupId, Long campaignId, List<String> includeWord, List<String> excludeWord, Boolean filterAdWord, Boolean filterAccountWord, List<String> recommendReasons, List<Long> province, List<Long> city, List<OrderByStructInfo> orderBy, List<String> fields, final ApiCallback<KeywordRecommendGetResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.keywordRecommendGetValidateBeforeCall(siteSets, recommendCategory, accountId, systemIndustryId, queryWord, businessPointId, adgroupId, campaignId, includeWord, excludeWord, filterAdWord, filterAccountWord, recommendReasons, province, city, orderBy, fields, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<KeywordRecommendGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

