/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api.v3;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.v3.LeadsCallRecordsGetResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class LeadsCallRecordsApi {
    private ApiClient apiClient;

    public LeadsCallRecordsApi() {
        this(Configuration.getV3DefaultApiClient());
    }

    public LeadsCallRecordsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call leadsCallRecordsGetCall(Long accountId, Long pageSize, Long page, String startDate, String endDate, String searchAfter, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/leads_call_records/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", pageSize));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start_date", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("end_date", endDate));
        }
        if (searchAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("search_after", searchAfter));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call leadsCallRecordsGetValidateBeforeCall(Long accountId, Long pageSize, Long page, String startDate, String endDate, String searchAfter, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling leadsCallRecordsGet(Async)");
        }
        if (pageSize == null) {
            throw new ApiException("Missing the required parameter 'pageSize' when calling leadsCallRecordsGet(Async)");
        }
        if (page == null) {
            throw new ApiException("Missing the required parameter 'page' when calling leadsCallRecordsGet(Async)");
        }
        if (startDate == null) {
            throw new ApiException("Missing the required parameter 'startDate' when calling leadsCallRecordsGet(Async)");
        }
        if (endDate == null) {
            throw new ApiException("Missing the required parameter 'endDate' when calling leadsCallRecordsGet(Async)");
        }
        Call call = this.leadsCallRecordsGetCall(accountId, pageSize, page, startDate, endDate, searchAfter, fields, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public LeadsCallRecordsGetResponse leadsCallRecordsGet(Long accountId, Long pageSize, Long page, String startDate, String endDate, String searchAfter, List<String> fields, String ... headerPair) throws ApiException {
        ApiResponse<LeadsCallRecordsGetResponse> resp = this.leadsCallRecordsGetWithHttpInfo(accountId, pageSize, page, startDate, endDate, searchAfter, fields, headerPair);
        return resp.getData();
    }

    public ApiResponse<LeadsCallRecordsGetResponse> leadsCallRecordsGetWithHttpInfo(Long accountId, Long pageSize, Long page, String startDate, String endDate, String searchAfter, List<String> fields, String ... headerPair) throws ApiException {
        Call call = this.leadsCallRecordsGetValidateBeforeCall(accountId, pageSize, page, startDate, endDate, searchAfter, fields, null, null, headerPair);
        Type localVarReturnType = new TypeToken<LeadsCallRecordsGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call leadsCallRecordsGetAsync(Long accountId, Long pageSize, Long page, String startDate, String endDate, String searchAfter, List<String> fields, final ApiCallback<LeadsCallRecordsGetResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.leadsCallRecordsGetValidateBeforeCall(accountId, pageSize, page, startDate, endDate, searchAfter, fields, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<LeadsCallRecordsGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

