/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api.v3;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.v3.LeadsVoipCallTokenGetResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class LeadsVoipCallTokenApi {
    private ApiClient apiClient;

    public LeadsVoipCallTokenApi() {
        this(Configuration.getV3DefaultApiClient());
    }

    public LeadsVoipCallTokenApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call leadsVoipCallTokenGetCall(Long accountId, Long userId, String requestId, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/leads_voip_call_token/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (userId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("user_id", userId));
        }
        if (requestId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("request_id", requestId));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call leadsVoipCallTokenGetValidateBeforeCall(Long accountId, Long userId, String requestId, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling leadsVoipCallTokenGet(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling leadsVoipCallTokenGet(Async)");
        }
        Call call = this.leadsVoipCallTokenGetCall(accountId, userId, requestId, fields, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public LeadsVoipCallTokenGetResponse leadsVoipCallTokenGet(Long accountId, Long userId, String requestId, List<String> fields, String ... headerPair) throws ApiException {
        ApiResponse<LeadsVoipCallTokenGetResponse> resp = this.leadsVoipCallTokenGetWithHttpInfo(accountId, userId, requestId, fields, headerPair);
        return resp.getData();
    }

    public ApiResponse<LeadsVoipCallTokenGetResponse> leadsVoipCallTokenGetWithHttpInfo(Long accountId, Long userId, String requestId, List<String> fields, String ... headerPair) throws ApiException {
        Call call = this.leadsVoipCallTokenGetValidateBeforeCall(accountId, userId, requestId, fields, null, null, headerPair);
        Type localVarReturnType = new TypeToken<LeadsVoipCallTokenGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call leadsVoipCallTokenGetAsync(Long accountId, Long userId, String requestId, List<String> fields, final ApiCallback<LeadsVoipCallTokenGetResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.leadsVoipCallTokenGetValidateBeforeCall(accountId, userId, requestId, fields, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<LeadsVoipCallTokenGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

