/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api.v3;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.v3.FilteringStruct;
import com.tencent.ads.model.v3.ProfilesAddRequest;
import com.tencent.ads.model.v3.ProfilesAddResponse;
import com.tencent.ads.model.v3.ProfilesDeleteRequest;
import com.tencent.ads.model.v3.ProfilesDeleteResponse;
import com.tencent.ads.model.v3.ProfilesGetResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ProfilesApi {
    private ApiClient apiClient;

    public ProfilesApi() {
        this(Configuration.getV3DefaultApiClient());
    }

    public ProfilesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call profilesAddCall(ProfilesAddRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        ProfilesAddRequest localVarPostBody = data;
        String localVarPath = "/profiles/add";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call profilesAddValidateBeforeCall(ProfilesAddRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling profilesAdd(Async)");
        }
        Call call = this.profilesAddCall(data, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public ProfilesAddResponse profilesAdd(ProfilesAddRequest data, String ... headerPair) throws ApiException {
        ApiResponse<ProfilesAddResponse> resp = this.profilesAddWithHttpInfo(data, headerPair);
        return resp.getData();
    }

    public ApiResponse<ProfilesAddResponse> profilesAddWithHttpInfo(ProfilesAddRequest data, String ... headerPair) throws ApiException {
        Call call = this.profilesAddValidateBeforeCall(data, null, null, headerPair);
        Type localVarReturnType = new TypeToken<ProfilesAddResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call profilesAddAsync(ProfilesAddRequest data, final ApiCallback<ProfilesAddResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.profilesAddValidateBeforeCall(data, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<ProfilesAddResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call profilesDeleteCall(ProfilesDeleteRequest data, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        ProfilesDeleteRequest localVarPostBody = data;
        String localVarPath = "/profiles/delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call profilesDeleteValidateBeforeCall(ProfilesDeleteRequest data, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling profilesDelete(Async)");
        }
        Call call = this.profilesDeleteCall(data, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public ProfilesDeleteResponse profilesDelete(ProfilesDeleteRequest data, String ... headerPair) throws ApiException {
        ApiResponse<ProfilesDeleteResponse> resp = this.profilesDeleteWithHttpInfo(data, headerPair);
        return resp.getData();
    }

    public ApiResponse<ProfilesDeleteResponse> profilesDeleteWithHttpInfo(ProfilesDeleteRequest data, String ... headerPair) throws ApiException {
        Call call = this.profilesDeleteValidateBeforeCall(data, null, null, headerPair);
        Type localVarReturnType = new TypeToken<ProfilesDeleteResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call profilesDeleteAsync(ProfilesDeleteRequest data, final ApiCallback<ProfilesDeleteResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.profilesDeleteValidateBeforeCall(data, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<ProfilesDeleteResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call profilesGetCall(Long accountId, List<FilteringStruct> filtering, Long page, Long pageSize, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/profiles/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (filtering != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "filtering", filtering));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call profilesGetValidateBeforeCall(Long accountId, List<FilteringStruct> filtering, Long page, Long pageSize, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling profilesGet(Async)");
        }
        Call call = this.profilesGetCall(accountId, filtering, page, pageSize, fields, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public ProfilesGetResponse profilesGet(Long accountId, List<FilteringStruct> filtering, Long page, Long pageSize, List<String> fields, String ... headerPair) throws ApiException {
        ApiResponse<ProfilesGetResponse> resp = this.profilesGetWithHttpInfo(accountId, filtering, page, pageSize, fields, headerPair);
        return resp.getData();
    }

    public ApiResponse<ProfilesGetResponse> profilesGetWithHttpInfo(Long accountId, List<FilteringStruct> filtering, Long page, Long pageSize, List<String> fields, String ... headerPair) throws ApiException {
        Call call = this.profilesGetValidateBeforeCall(accountId, filtering, page, pageSize, fields, null, null, headerPair);
        Type localVarReturnType = new TypeToken<ProfilesGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call profilesGetAsync(Long accountId, List<FilteringStruct> filtering, Long page, Long pageSize, List<String> fields, final ApiCallback<ProfilesGetResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.profilesGetValidateBeforeCall(accountId, filtering, page, pageSize, fields, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<ProfilesGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

