/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api.v3;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.v3.QualificationImagesAddResponse;
import com.tencent.ads.model.v3.QualificationImagesGetResponse;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class QualificationImagesApi {
    private ApiClient apiClient;

    public QualificationImagesApi() {
        this(Configuration.getV3DefaultApiClient());
    }

    public QualificationImagesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call qualificationImagesAddCall(Long accountId, String signature, File file, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/qualification_images/add";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (accountId != null) {
            localVarFormParams.put("account_id", accountId);
        }
        if (signature != null) {
            localVarFormParams.put("signature", signature);
        }
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call qualificationImagesAddValidateBeforeCall(Long accountId, String signature, File file, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling qualificationImagesAdd(Async)");
        }
        if (signature == null) {
            throw new ApiException("Missing the required parameter 'signature' when calling qualificationImagesAdd(Async)");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling qualificationImagesAdd(Async)");
        }
        Call call = this.qualificationImagesAddCall(accountId, signature, file, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public QualificationImagesAddResponse qualificationImagesAdd(Long accountId, String signature, File file, String ... headerPair) throws ApiException {
        ApiResponse<QualificationImagesAddResponse> resp = this.qualificationImagesAddWithHttpInfo(accountId, signature, file, headerPair);
        return resp.getData();
    }

    public ApiResponse<QualificationImagesAddResponse> qualificationImagesAddWithHttpInfo(Long accountId, String signature, File file, String ... headerPair) throws ApiException {
        Call call = this.qualificationImagesAddValidateBeforeCall(accountId, signature, file, null, null, headerPair);
        Type localVarReturnType = new TypeToken<QualificationImagesAddResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call qualificationImagesAddAsync(Long accountId, String signature, File file, final ApiCallback<QualificationImagesAddResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.qualificationImagesAddValidateBeforeCall(accountId, signature, file, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<QualificationImagesAddResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call qualificationImagesGetCall(Long accountId, List<String> imageIds, Long page, Long pageSize, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/qualification_images/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (imageIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "image_ids", imageIds));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call qualificationImagesGetValidateBeforeCall(Long accountId, List<String> imageIds, Long page, Long pageSize, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling qualificationImagesGet(Async)");
        }
        if (imageIds == null) {
            throw new ApiException("Missing the required parameter 'imageIds' when calling qualificationImagesGet(Async)");
        }
        if (page == null) {
            throw new ApiException("Missing the required parameter 'page' when calling qualificationImagesGet(Async)");
        }
        if (pageSize == null) {
            throw new ApiException("Missing the required parameter 'pageSize' when calling qualificationImagesGet(Async)");
        }
        Call call = this.qualificationImagesGetCall(accountId, imageIds, page, pageSize, fields, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public QualificationImagesGetResponse qualificationImagesGet(Long accountId, List<String> imageIds, Long page, Long pageSize, List<String> fields, String ... headerPair) throws ApiException {
        ApiResponse<QualificationImagesGetResponse> resp = this.qualificationImagesGetWithHttpInfo(accountId, imageIds, page, pageSize, fields, headerPair);
        return resp.getData();
    }

    public ApiResponse<QualificationImagesGetResponse> qualificationImagesGetWithHttpInfo(Long accountId, List<String> imageIds, Long page, Long pageSize, List<String> fields, String ... headerPair) throws ApiException {
        Call call = this.qualificationImagesGetValidateBeforeCall(accountId, imageIds, page, pageSize, fields, null, null, headerPair);
        Type localVarReturnType = new TypeToken<QualificationImagesGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call qualificationImagesGetAsync(Long accountId, List<String> imageIds, Long page, Long pageSize, List<String> fields, final ApiCallback<QualificationImagesGetResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.qualificationImagesGetValidateBeforeCall(accountId, imageIds, page, pageSize, fields, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<QualificationImagesGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

