/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api.v3;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.v3.OrderByStruct;
import com.tencent.ads.model.v3.ReportDateRange;
import com.tencent.ads.model.v3.TargetingFilteringStruct;
import com.tencent.ads.model.v3.TargetingTagReportsGetResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TargetingTagReportsApi {
    private ApiClient apiClient;

    public TargetingTagReportsApi() {
        this(Configuration.getV3DefaultApiClient());
    }

    public TargetingTagReportsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call targetingTagReportsGetCall(Long accountId, String type, String level, ReportDateRange dateRange, List<String> groupBy, List<String> fields, List<TargetingFilteringStruct> filtering, List<OrderByStruct> orderBy, String timeLine, Long page, Long pageSize, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/targeting_tag_reports/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        }
        if (level != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("level", level));
        }
        if (dateRange != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("date_range", dateRange));
        }
        if (filtering != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "filtering", filtering));
        }
        if (groupBy != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "group_by", groupBy));
        }
        if (orderBy != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "order_by", orderBy));
        }
        if (timeLine != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("time_line", timeLine));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (headerPair != null && headerPair.length > 0) {
            if (headerPair.length % 2 != 0) {
                throw new UnsupportedOperationException("Parameter headerPair must be paired");
            }
            for (int i = 0; i < headerPair.length / 2; ++i) {
                localVarHeaderParams.put(headerPair[i], headerPair[i * 2 + 1]);
            }
        }
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call targetingTagReportsGetValidateBeforeCall(Long accountId, String type, String level, ReportDateRange dateRange, List<String> groupBy, List<String> fields, List<TargetingFilteringStruct> filtering, List<OrderByStruct> orderBy, String timeLine, Long page, Long pageSize, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, String ... headerPair) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling targetingTagReportsGet(Async)");
        }
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling targetingTagReportsGet(Async)");
        }
        if (level == null) {
            throw new ApiException("Missing the required parameter 'level' when calling targetingTagReportsGet(Async)");
        }
        if (dateRange == null) {
            throw new ApiException("Missing the required parameter 'dateRange' when calling targetingTagReportsGet(Async)");
        }
        if (groupBy == null) {
            throw new ApiException("Missing the required parameter 'groupBy' when calling targetingTagReportsGet(Async)");
        }
        if (fields == null) {
            throw new ApiException("Missing the required parameter 'fields' when calling targetingTagReportsGet(Async)");
        }
        Call call = this.targetingTagReportsGetCall(accountId, type, level, dateRange, groupBy, fields, filtering, orderBy, timeLine, page, pageSize, progressListener, progressRequestListener, headerPair);
        return call;
    }

    public TargetingTagReportsGetResponse targetingTagReportsGet(Long accountId, String type, String level, ReportDateRange dateRange, List<String> groupBy, List<String> fields, List<TargetingFilteringStruct> filtering, List<OrderByStruct> orderBy, String timeLine, Long page, Long pageSize, String ... headerPair) throws ApiException {
        ApiResponse<TargetingTagReportsGetResponse> resp = this.targetingTagReportsGetWithHttpInfo(accountId, type, level, dateRange, groupBy, fields, filtering, orderBy, timeLine, page, pageSize, headerPair);
        return resp.getData();
    }

    public ApiResponse<TargetingTagReportsGetResponse> targetingTagReportsGetWithHttpInfo(Long accountId, String type, String level, ReportDateRange dateRange, List<String> groupBy, List<String> fields, List<TargetingFilteringStruct> filtering, List<OrderByStruct> orderBy, String timeLine, Long page, Long pageSize, String ... headerPair) throws ApiException {
        Call call = this.targetingTagReportsGetValidateBeforeCall(accountId, type, level, dateRange, groupBy, fields, filtering, orderBy, timeLine, page, pageSize, null, null, headerPair);
        Type localVarReturnType = new TypeToken<TargetingTagReportsGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call targetingTagReportsGetAsync(Long accountId, String type, String level, ReportDateRange dateRange, List<String> groupBy, List<String> fields, List<TargetingFilteringStruct> filtering, List<OrderByStruct> orderBy, String timeLine, Long page, Long pageSize, final ApiCallback<TargetingTagReportsGetResponse> callback, String ... headerPair) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.targetingTagReportsGetValidateBeforeCall(accountId, type, level, dateRange, groupBy, fields, filtering, orderBy, timeLine, page, pageSize, progressListener, progressRequestListener, headerPair);
        Type localVarReturnType = new TypeToken<TargetingTagReportsGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

