/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.examples.BasicOperations.Adsmanagement;

import com.tencent.ads.ApiContextConfig;
import com.tencent.ads.TencentAds;
import com.tencent.ads.exception.TencentAdsResponseException;
import com.tencent.ads.exception.TencentAdsSDKException;
import com.tencent.ads.model.BatchOperationAddRequest;
import com.tencent.ads.model.BatchOperationAddResponse;
import com.tencent.ads.model.BatchOperationType;
import com.tencent.ads.model.DateSpec;
import com.tencent.ads.model.OperationSpec;
import com.tencent.ads.model.ResourceType;
import java.util.Arrays;
import java.util.List;

public class AddBatchOperation {
    public String ACCESS_TOKEN = "YOUR ACCESS TOKEN";
    public TencentAds tencentAds;
    public Long accountId = null;
    public BatchOperationAddRequest data = new BatchOperationAddRequest();
    public BatchOperationType operationType = BatchOperationType.DATE;
    public List<Long> resourceIdList = Arrays.asList(0L);
    public String beginDate = "YOUR ADGROUP BEGIN DATE";
    public String endDate = "YOUR ADGROUP END DATE";
    public ResourceType resourceType = ResourceType.RESOURCE_TYPE_ADGROUP;

    public void init() {
        this.tencentAds = TencentAds.getInstance();
        this.tencentAds.init(new ApiContextConfig().accessToken(this.ACCESS_TOKEN).isDebug(true));
        this.buildParams();
    }

    public void buildParams() {
        this.data.setAccountId(this.accountId);
        this.data.setOperationType(this.operationType);
        this.data.setResourceIdList(this.resourceIdList);
        DateSpec dateSpec = new DateSpec();
        dateSpec.setBeginDate(this.beginDate);
        dateSpec.setEndDate(this.endDate);
        OperationSpec operationSpec = new OperationSpec();
        operationSpec.setDateSpec(dateSpec);
        this.data.setOperationSpec(operationSpec);
        this.data.setResourceType(this.resourceType);
    }

    public BatchOperationAddResponse addBatchOperation() throws Exception {
        BatchOperationAddResponse response = this.tencentAds.batchOperation().batchOperationAdd(this.data, new String[0]);
        return response;
    }

    public static void main(String[] args) {
        try {
            AddBatchOperation addBatchOperation = new AddBatchOperation();
            addBatchOperation.init();
            BatchOperationAddResponse batchOperationAddResponse = addBatchOperation.addBatchOperation();
        }
        catch (TencentAdsResponseException e) {
            e.printStackTrace();
        }
        catch (TencentAdsSDKException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

