/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.examples.BasicOperations.Adsmanagement;

import com.tencent.ads.ApiContextConfig;
import com.tencent.ads.TencentAds;
import com.tencent.ads.exception.TencentAdsResponseException;
import com.tencent.ads.exception.TencentAdsSDKException;
import com.tencent.ads.model.CampaignType;
import com.tencent.ads.model.DestinationType;
import com.tencent.ads.model.DynamicCreativeElements;
import com.tencent.ads.model.DynamicCreativePageSpec;
import com.tencent.ads.model.DynamicCreativesAddRequest;
import com.tencent.ads.model.DynamicCreativesAddResponseData;
import com.tencent.ads.model.PromotedObjectType;
import java.util.Arrays;
import java.util.List;

public class AddDynamicCreatives {
    public String ACCESS_TOKEN = "YOUR ACCESS TOKEN";
    public TencentAds tencentAds;
    public Long accountId = null;
    public DynamicCreativesAddRequest data = new DynamicCreativesAddRequest();
    public List<String> imageOptions = Arrays.asList("YOUR AD IMAGE");
    public List<String> titleOptions = Arrays.asList("YOUR AD TEXT 1", "YOUR AD TEXT 2");
    public List<String> descriptionOptions = Arrays.asList("YOUR AD DESCRIPTION");
    public DestinationType pageType = DestinationType.DEFAULT;
    public String pageUrl = "YOUR AD PAGE URL";
    public CampaignType campaignType = CampaignType.NORMAL;
    public PromotedObjectType promotedObjectType = PromotedObjectType.LINK;
    public List<String> siteSet = Arrays.asList("SITE_SET_MOBILE_INNER");
    public Long dynamicCreativeTemplateId = 717L;
    public String dynamicCreativeName = "SDK\u52a8\u6001\u521b\u610f5ede25293ba60";

    public void init() {
        this.tencentAds = TencentAds.getInstance();
        this.tencentAds.init(new ApiContextConfig().accessToken(this.ACCESS_TOKEN).isDebug(true));
        this.buildParams();
    }

    public void buildParams() {
        this.data.setAccountId(this.accountId);
        DynamicCreativeElements dynamicCreativeElements = new DynamicCreativeElements();
        dynamicCreativeElements.setImageOptions(this.imageOptions);
        dynamicCreativeElements.setTitleOptions(this.titleOptions);
        dynamicCreativeElements.setDescriptionOptions(this.descriptionOptions);
        this.data.setDynamicCreativeElements(dynamicCreativeElements);
        this.data.setPageType(this.pageType);
        DynamicCreativePageSpec pageSpec = new DynamicCreativePageSpec();
        pageSpec.setPageUrl(this.pageUrl);
        this.data.setPageSpec(pageSpec);
        this.data.setCampaignType(this.campaignType);
        this.data.setPromotedObjectType(this.promotedObjectType);
        this.data.setSiteSet(this.siteSet);
        this.data.setDynamicCreativeTemplateId(this.dynamicCreativeTemplateId);
        this.data.setDynamicCreativeName(this.dynamicCreativeName);
    }

    public DynamicCreativesAddResponseData addDynamicCreatives() throws Exception {
        DynamicCreativesAddResponseData response = this.tencentAds.dynamicCreatives().dynamicCreativesAdd(this.data, new String[0]);
        return response;
    }

    public static void main(String[] args) {
        try {
            AddDynamicCreatives addDynamicCreatives = new AddDynamicCreatives();
            addDynamicCreatives.init();
            DynamicCreativesAddResponseData dynamicCreativesAddResponseData = addDynamicCreatives.addDynamicCreatives();
        }
        catch (TencentAdsResponseException e) {
            e.printStackTrace();
        }
        catch (TencentAdsSDKException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

