/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.examples.BasicOperations.AudiencesManagement;

import com.tencent.ads.ApiContextConfig;
import com.tencent.ads.TencentAds;
import com.tencent.ads.exception.TencentAdsResponseException;
import com.tencent.ads.exception.TencentAdsSDKException;
import com.tencent.ads.model.AudienceGrantRelationsAddGrantSpec;
import com.tencent.ads.model.AudienceGrantRelationsAddGrantToBusinessSpec;
import com.tencent.ads.model.AudienceGrantRelationsAddRequest;
import com.tencent.ads.model.AudienceGrantRelationsAddResponse;
import com.tencent.ads.model.AudienceGrantScopeType;
import com.tencent.ads.model.AudienceGrantType;
import com.tencent.ads.model.GrantBusinessPermission;
import java.util.Arrays;
import java.util.List;

public class AddAudienceGrantRelations {
    public String ACCESS_TOKEN = "YOUR ACCESS TOKEN";
    public TencentAds tencentAds;
    public Long accountId = null;
    public AudienceGrantRelationsAddRequest data = new AudienceGrantRelationsAddRequest();
    public AudienceGrantType grantType = AudienceGrantType.GRANT_TYPE_BUSINESS;
    public Long grantBusinessId = null;
    public AudienceGrantScopeType grantScopeType = AudienceGrantScopeType.BUSINESS;
    public List<String> grantPermissionTypeList = Arrays.asList("GRANT_PERMISSION_TYPE_TARGET");
    public List<Long> audienceIdList = Arrays.asList(0L);

    public void init() {
        this.tencentAds = TencentAds.getInstance();
        this.tencentAds.init(new ApiContextConfig().accessToken(this.ACCESS_TOKEN).isDebug(true));
        this.buildParams();
    }

    public void buildParams() {
        this.data.setAccountId(this.accountId);
        this.data.setGrantType(this.grantType);
        AudienceGrantRelationsAddGrantToBusinessSpec grantToBusinessSpec = new AudienceGrantRelationsAddGrantToBusinessSpec();
        grantToBusinessSpec.setGrantBusinessId(this.grantBusinessId);
        grantToBusinessSpec.setGrantScopeType(this.grantScopeType);
        GrantBusinessPermission grantBusinessPermission = new GrantBusinessPermission();
        grantBusinessPermission.setGrantPermissionTypeList(this.grantPermissionTypeList);
        grantToBusinessSpec.setGrantBusinessPermission(grantBusinessPermission);
        AudienceGrantRelationsAddGrantSpec grantSpec = new AudienceGrantRelationsAddGrantSpec();
        grantSpec.setGrantToBusinessSpec(grantToBusinessSpec);
        this.data.setGrantSpec(grantSpec);
        this.data.setAudienceIdList(this.audienceIdList);
    }

    public AudienceGrantRelationsAddResponse addAudienceGrantRelations() throws Exception {
        AudienceGrantRelationsAddResponse response = this.tencentAds.audienceGrantRelations().audienceGrantRelationsAdd(this.data, new String[0]);
        return response;
    }

    public static void main(String[] args) {
        try {
            AddAudienceGrantRelations addAudienceGrantRelations = new AddAudienceGrantRelations();
            addAudienceGrantRelations.init();
            AudienceGrantRelationsAddResponse audienceGrantRelationsAddResponse = addAudienceGrantRelations.addAudienceGrantRelations();
        }
        catch (TencentAdsResponseException e) {
            e.printStackTrace();
        }
        catch (TencentAdsSDKException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

