/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.examples.BasicOperations.BusinessAssets;

import com.tencent.ads.ApiContextConfig;
import com.tencent.ads.TencentAds;
import com.tencent.ads.exception.TencentAdsResponseException;
import com.tencent.ads.exception.TencentAdsSDKException;
import com.tencent.ads.model.AssetPermissionGrantType;
import com.tencent.ads.model.AssetPermissionSpecStruct;
import com.tencent.ads.model.AssetPermissionsAddRequest;
import com.tencent.ads.model.AssetPermissionsAddResponseData;
import com.tencent.ads.model.AssetType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AddAssetPermissions {
    public String ACCESS_TOKEN = "YOUR ACCESS TOKEN";
    public TencentAds tencentAds;
    public List<Long> licensingAccountIdList = Arrays.asList(0L);
    public AssetPermissionsAddRequest data = new AssetPermissionsAddRequest();
    public Long accountId = null;
    public AssetType assetType = AssetType.CANVAS_WECHAT;
    public AssetPermissionGrantType assetPermissionGrantType = AssetPermissionGrantType.ASSET;
    public Long assetId = null;

    public void init() {
        this.tencentAds = TencentAds.getInstance();
        this.tencentAds.init(new ApiContextConfig().accessToken(this.ACCESS_TOKEN).isDebug(true));
        this.buildParams();
    }

    public void buildParams() {
        this.data.setLicensingAccountIdList(this.licensingAccountIdList);
        this.data.setAccountId(this.accountId);
        this.data.setAssetType(this.assetType);
        AssetPermissionSpecStruct assetPermissionSpecStruct = new AssetPermissionSpecStruct();
        assetPermissionSpecStruct.setAssetPermissionGrantType(this.assetPermissionGrantType);
        assetPermissionSpecStruct.setAssetId(this.assetId);
        ArrayList<AssetPermissionSpecStruct> assetPermissionSpec = new ArrayList<AssetPermissionSpecStruct>();
        assetPermissionSpec.add(assetPermissionSpecStruct);
        this.data.setAssetPermissionSpec(assetPermissionSpec);
    }

    public AssetPermissionsAddResponseData addAssetPermissions() throws Exception {
        AssetPermissionsAddResponseData response = this.tencentAds.assetPermissions().assetPermissionsAdd(this.data, new String[0]);
        return response;
    }

    public static void main(String[] args) {
        try {
            AddAssetPermissions addAssetPermissions = new AddAssetPermissions();
            addAssetPermissions.init();
            AssetPermissionsAddResponseData assetPermissionsAddResponseData = addAssetPermissions.addAssetPermissions();
        }
        catch (TencentAdsResponseException e) {
            e.printStackTrace();
        }
        catch (TencentAdsSDKException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

