/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.examples.BasicOperations.BusinessAssets;

import com.tencent.ads.ApiContextConfig;
import com.tencent.ads.TencentAds;
import com.tencent.ads.exception.TencentAdsResponseException;
import com.tencent.ads.exception.TencentAdsSDKException;
import com.tencent.ads.model.ProductItemSpec;
import com.tencent.ads.model.ProductItemsAddRequest;
import com.tencent.ads.model.ProductItemsAddResponseData;
import java.util.ArrayList;

public class AddProductItems {
    public String ACCESS_TOKEN = "YOUR ACCESS TOKEN";
    public TencentAds tencentAds;
    public Long productCatalogId = null;
    public ProductItemsAddRequest data = new ProductItemsAddRequest();
    public Long accountId = null;
    public String productOuterId = "YOUR PRODUCT ID";
    public String productName = "YOUR PRODUCT NAME";
    public String expirationTime = "2021-06-08 11:46:51";
    public Long stockVolume = 10L;
    public String imageUrl = "YOUR PRODUCT IMAGE URL";
    public String description = "SDK sample";

    public void init() {
        this.tencentAds = TencentAds.getInstance();
        this.tencentAds.init(new ApiContextConfig().accessToken(this.ACCESS_TOKEN).isDebug(true));
        this.buildParams();
    }

    public void buildParams() {
        this.data.setProductCatalogId(this.productCatalogId);
        this.data.setAccountId(this.accountId);
        ProductItemSpec productItemSpec = new ProductItemSpec();
        productItemSpec.setProductOuterId(this.productOuterId);
        productItemSpec.setProductName(this.productName);
        productItemSpec.setExpirationTime(this.expirationTime);
        productItemSpec.setStockVolume(this.stockVolume);
        productItemSpec.setImageUrl(this.imageUrl);
        productItemSpec.setDescription(this.description);
        ArrayList<ProductItemSpec> productItemSpecList = new ArrayList<ProductItemSpec>();
        productItemSpecList.add(productItemSpec);
        this.data.setProductItemSpecList(productItemSpecList);
    }

    public ProductItemsAddResponseData addProductItems() throws Exception {
        ProductItemsAddResponseData response = this.tencentAds.productItems().productItemsAdd(this.data, new String[0]);
        return response;
    }

    public static void main(String[] args) {
        try {
            AddProductItems addProductItems = new AddProductItems();
            addProductItems.init();
            ProductItemsAddResponseData productItemsAddResponseData = addProductItems.addProductItems();
        }
        catch (TencentAdsResponseException e) {
            e.printStackTrace();
        }
        catch (TencentAdsSDKException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

