/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.examples.BasicOperations.Tools;

import com.tencent.ads.ApiContextConfig;
import com.tencent.ads.TencentAds;
import com.tencent.ads.exception.TencentAdsResponseException;
import com.tencent.ads.exception.TencentAdsSDKException;
import com.tencent.ads.model.AgeStruct;
import com.tencent.ads.model.CampaignTargeting;
import com.tencent.ads.model.EstimationGetRequest;
import com.tencent.ads.model.EstimationGetResponseData;
import com.tencent.ads.model.EstimationReadTargetingSetting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GetEstimation {
    public String ACCESS_TOKEN = "YOUR ACCESS TOKEN";
    public TencentAds tencentAds;
    public Long max = null;
    public Long min = null;
    public List<String> gender = Arrays.asList("YOUR TARGETING GENDER");
    public EstimationGetRequest data = new EstimationGetRequest();
    public Long accountId = null;
    public Long campaignId = null;

    public void init() {
        this.tencentAds = TencentAds.getInstance();
        this.tencentAds.init(new ApiContextConfig().accessToken(this.ACCESS_TOKEN).isDebug(true));
        this.buildParams();
    }

    public void buildParams() {
        AgeStruct ageStruct = new AgeStruct();
        ageStruct.setMax(this.max);
        ageStruct.setMin(this.min);
        ArrayList<AgeStruct> age = new ArrayList<AgeStruct>();
        age.add(ageStruct);
        EstimationReadTargetingSetting targeting = new EstimationReadTargetingSetting();
        targeting.setAge(age);
        targeting.setGender(this.gender);
        this.data.setTargeting(targeting);
        this.data.setAccountId(this.accountId);
        CampaignTargeting campaignSpec = new CampaignTargeting();
        campaignSpec.setCampaignId(this.campaignId);
        this.data.setCampaignSpec(campaignSpec);
    }

    public EstimationGetResponseData getEstimation() throws Exception {
        EstimationGetResponseData response = this.tencentAds.estimation().estimationGet(this.data, new String[0]);
        return response;
    }

    public static void main(String[] args) {
        try {
            GetEstimation getEstimation = new GetEstimation();
            getEstimation.init();
            EstimationGetResponseData estimationGetResponseData = getEstimation.getEstimation();
        }
        catch (TencentAdsResponseException e) {
            e.printStackTrace();
        }
        catch (TencentAdsSDKException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

