/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.examples.v3.AccountManagement.AccountType;

import com.tencent.ads.ApiContextConfig;
import com.tencent.ads.exception.TencentAdsResponseException;
import com.tencent.ads.exception.TencentAdsSDKException;
import com.tencent.ads.model.v3.AccountTypeMap;
import com.tencent.ads.model.v3.FundTransferAddRequest;
import com.tencent.ads.model.v3.FundTransferAddResponseData;
import com.tencent.ads.v3.TencentAds;

public class AddFundTransfer {
    public String ACCESS_TOKEN = "YOUR ACCESS TOKEN";
    public TencentAds tencentAds;
    public Long amount = null;
    public FundTransferAddRequest data = new FundTransferAddRequest();
    public Long accountId = null;
    public AccountTypeMap fundType = AccountTypeMap.GIFT;
    public String transferType = "AGENCY_TO_ADVERTISER";

    public void init() {
        this.tencentAds = TencentAds.getInstance();
        this.tencentAds.init(new ApiContextConfig().accessToken(this.ACCESS_TOKEN).isDebug(true));
        this.buildParams();
    }

    public void buildParams() {
        this.data.setAmount(this.amount);
        this.data.setAccountId(this.accountId);
        this.data.setFundType(this.fundType);
        this.data.setTransferType(this.transferType);
    }

    public FundTransferAddResponseData addFundTransfer() throws Exception {
        FundTransferAddResponseData response = this.tencentAds.fundTransfer().fundTransferAdd(this.data, new String[0]);
        return response;
    }

    public static void main(String[] args) {
        try {
            AddFundTransfer addFundTransfer = new AddFundTransfer();
            addFundTransfer.init();
            FundTransferAddResponseData fundTransferAddResponseData = addFundTransfer.addFundTransfer();
        }
        catch (TencentAdsResponseException e) {
            e.printStackTrace();
        }
        catch (TencentAdsSDKException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

