/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.examples.v3.AccountManagement.Qualification;

import com.tencent.ads.ApiContextConfig;
import com.tencent.ads.exception.TencentAdsResponseException;
import com.tencent.ads.exception.TencentAdsSDKException;
import com.tencent.ads.model.v3.AdditionalIndustryQualificationsSpec;
import com.tencent.ads.model.v3.QualificationSpec;
import com.tencent.ads.model.v3.QualificationType;
import com.tencent.ads.model.v3.QualificationsAddRequest;
import com.tencent.ads.model.v3.QualificationsAddResponseData;
import com.tencent.ads.v3.TencentAds;
import java.util.Arrays;
import java.util.List;

public class AddQualifications {
    public String ACCESS_TOKEN = "YOUR ACCESS TOKEN";
    public TencentAds tencentAds;
    public Long accountId = null;
    public QualificationsAddRequest data = new QualificationsAddRequest();
    public QualificationType qualificationType = QualificationType.ADDITIONAL_INDUSTRY_QUALIFICATION;
    public Long systemIndustryId = null;
    public String qualificationCode = "YOUR QUALIFICATION CODE";
    public List<String> imageIdList = Arrays.asList("YOUR QUALIFICATION IMAGE ID");

    public void init() {
        this.tencentAds = TencentAds.getInstance();
        this.tencentAds.init(new ApiContextConfig().accessToken(this.ACCESS_TOKEN).isDebug(true));
        this.buildParams();
    }

    public void buildParams() {
        this.data.setAccountId(this.accountId);
        this.data.setQualificationType(this.qualificationType);
        AdditionalIndustryQualificationsSpec additionalIndustrySpec = new AdditionalIndustryQualificationsSpec();
        additionalIndustrySpec.setSystemIndustryId(this.systemIndustryId);
        additionalIndustrySpec.setQualificationCode(this.qualificationCode);
        additionalIndustrySpec.setImageIdList(this.imageIdList);
        QualificationSpec qualificationSpec = new QualificationSpec();
        qualificationSpec.setAdditionalIndustrySpec(additionalIndustrySpec);
        this.data.setQualificationSpec(qualificationSpec);
    }

    public QualificationsAddResponseData addQualifications() throws Exception {
        QualificationsAddResponseData response = this.tencentAds.qualifications().qualificationsAdd(this.data, new String[0]);
        return response;
    }

    public static void main(String[] args) {
        try {
            AddQualifications addQualifications = new AddQualifications();
            addQualifications.init();
            QualificationsAddResponseData qualificationsAddResponseData = addQualifications.addQualifications();
        }
        catch (TencentAdsResponseException e) {
            e.printStackTrace();
        }
        catch (TencentAdsSDKException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

