/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.guice.interceptors;

import com.tencent.ads.ApiClient;
import com.tencent.ads.Configuration;
import com.tencent.ads.anno.NoInterceptor;
import com.tencent.ads.auth.ApiKeyAuth;
import com.tencent.ads.utils.DigestUtils;
import java.util.UUID;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class AuthInterceptor
implements MethodInterceptor {
    private static ApiClient defaultApiClient = Configuration.getDefaultApiClient();
    private static ApiClient v3DefaultApiClient = Configuration.getV3DefaultApiClient();

    public Object invoke(MethodInvocation invocation) throws Throwable {
        ApiKeyAuth nonce;
        if (invocation.getMethod().isAnnotationPresent(NoInterceptor.class)) {
            Object ret = invocation.proceed();
            return ret;
        }
        Class<?> keyClass = invocation.getThis().getClass();
        boolean isV3 = keyClass.getName().contains(".v3");
        if (isV3) {
            nonce = (ApiKeyAuth)v3DefaultApiClient.getAuthentication("nonce");
            nonce.setApiKey(DigestUtils.encrypt(UUID.randomUUID().toString()));
            ApiKeyAuth timestamp = (ApiKeyAuth)v3DefaultApiClient.getAuthentication("timestamp");
            timestamp.setApiKey(String.valueOf(System.currentTimeMillis() / 1000L));
        } else {
            nonce = (ApiKeyAuth)defaultApiClient.getAuthentication("nonce");
            nonce.setApiKey(DigestUtils.encrypt(UUID.randomUUID().toString()));
            ApiKeyAuth timestamp = (ApiKeyAuth)defaultApiClient.getAuthentication("timestamp");
            timestamp.setApiKey(String.valueOf(System.currentTimeMillis() / 1000L));
        }
        Object ret = invocation.proceed();
        return ret;
    }
}

