/*
 * Decompiled with CFR 0.152.
 */
package com.tinet.clink.livechat.request;

import com.tinet.clink.core.utils.HttpMethodType;
import com.tinet.clink.livechat.PathEnum;
import com.tinet.clink.livechat.request.stat.AbstractStatRequest;
import com.tinet.clink.livechat.response.StatQueuePeriodListResponse;
import java.util.List;
import java.util.stream.Collectors;

public class StatQueuePeriodListRequest
extends AbstractStatRequest<StatQueuePeriodListResponse> {
    private String startTime;
    private String endTime;
    @Deprecated
    private List<Integer> appType;
    private List<Integer> contactTypes;
    private List<String> qnos;
    private Integer periodType;

    public Integer getPeriodType() {
        return this.periodType;
    }

    public void setPeriodType(Integer periodType) {
        this.periodType = periodType;
        if (periodType != null) {
            this.putQueryParameter("periodType", periodType);
        }
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
        if (startTime != null) {
            this.putQueryParameter("startTime", startTime);
        }
    }

    public List<Integer> getContactTypes() {
        return this.contactTypes;
    }

    public void setContactTypes(List<Integer> contactTypes) {
        this.contactTypes = contactTypes;
        if (contactTypes != null && contactTypes.size() != 0) {
            this.putQueryParameter("contactTypes", StatQueuePeriodListRequest.convertIntegerListToString(contactTypes));
        }
    }

    public List<Integer> getAppType() {
        return this.appType;
    }

    public void setAppType(List<Integer> appType) {
        this.appType = appType;
        if (appType != null && appType.size() != 0) {
            this.putQueryParameter("appType", StatQueuePeriodListRequest.convertIntegerListToString(appType));
        }
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
        if (endTime != null) {
            this.putQueryParameter("endTime", endTime);
        }
    }

    public List<String> getQnos() {
        return this.qnos;
    }

    public void setQnos(List<String> qnos) {
        this.qnos = qnos;
        if (qnos != null && qnos.size() != 0) {
            this.putQueryParameter("qnos", StatQueuePeriodListRequest.convertStringListToString(qnos));
        }
    }

    @Override
    public Class<StatQueuePeriodListResponse> getResponseClass() {
        return StatQueuePeriodListResponse.class;
    }

    public StatQueuePeriodListRequest() {
        super(PathEnum.statQueuePeriodList.value(), HttpMethodType.POST);
    }

    private static String convertStringListToString(List<String> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.stream().collect(Collectors.joining(","));
    }

    private static String convertIntegerListToString(List<Integer> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.stream().map(Object::toString).collect(Collectors.joining(","));
    }
}

