/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.ContentType;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.unfbx.chatgpt.entity.chat.ChatCompletion;
import com.unfbx.chatgpt.entity.chat.Message;
import com.unfbx.chatgpt.entity.completions.Completion;
import com.unfbx.chatgpt.exception.BaseException;
import com.unfbx.chatgpt.exception.CommonError;
import java.net.Proxy;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAiStreamClient {
    private static final Logger log = LoggerFactory.getLogger(OpenAiStreamClient.class);
    @NotNull
    private String apiKey;
    private OkHttpClient okHttpClient;
    private long connectTimeout;
    private long writeTimeout;
    private long readTimeout;
    private Proxy proxy;

    public OpenAiStreamClient(String apiKey, long connectTimeout, long writeTimeout, long readTimeout, Proxy proxy) {
        this.apiKey = apiKey;
        this.connectTimeout = connectTimeout;
        this.writeTimeout = writeTimeout;
        this.readTimeout = readTimeout;
        this.proxy = proxy;
        this.okHttpClient(connectTimeout, writeTimeout, readTimeout, proxy);
    }

    public OpenAiStreamClient(String apiKey, long connectTimeout, long writeTimeout, long readTimeout) {
        this.apiKey = apiKey;
        this.connectTimeout = connectTimeout;
        this.writeTimeout = writeTimeout;
        this.readTimeout = readTimeout;
        this.okHttpClient(connectTimeout, writeTimeout, readTimeout, null);
    }

    public OpenAiStreamClient(String apiKey) {
        this.apiKey = apiKey;
        this.okHttpClient(30L, 30L, 30L, null);
    }

    public OpenAiStreamClient(String apiKey, Proxy proxy) {
        this.apiKey = apiKey;
        this.proxy = proxy;
        this.okHttpClient(30L, 30L, 30L, proxy);
    }

    private OpenAiStreamClient(Builder builder) {
        if (StrUtil.isBlank((CharSequence)builder.apiKey)) {
            throw new BaseException(CommonError.API_KEYS_NOT_NUL);
        }
        this.apiKey = builder.apiKey;
        if (Objects.isNull(builder.connectTimeout)) {
            builder.connectTimeout(30L);
        }
        this.connectTimeout = builder.connectTimeout;
        if (Objects.isNull(builder.writeTimeout)) {
            builder.writeTimeout(30L);
        }
        this.writeTimeout = builder.writeTimeout;
        if (Objects.isNull(builder.readTimeout)) {
            builder.readTimeout(30L);
        }
        this.readTimeout = builder.readTimeout;
        this.proxy = builder.proxy;
        this.okHttpClient(this.connectTimeout, this.writeTimeout, this.readTimeout, this.proxy);
    }

    private void okHttpClient(long connectTimeout, long writeTimeout, long readTimeout, Proxy proxy) {
        OkHttpClient.Builder client = new OkHttpClient.Builder();
        client.connectTimeout(connectTimeout, TimeUnit.SECONDS);
        client.writeTimeout(writeTimeout, TimeUnit.SECONDS);
        client.readTimeout(readTimeout, TimeUnit.SECONDS);
        if (Objects.nonNull(proxy)) {
            client.proxy(proxy);
        }
        this.okHttpClient = client.build();
    }

    public void streamCompletions(Completion completion, EventSourceListener eventSourceListener) {
        if (Objects.isNull(eventSourceListener)) {
            log.error("\u53c2\u6570\u5f02\u5e38\uff1aEventSourceListener\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u53ef\u4ee5\u53c2\u8003\uff1acom.unfbx.chatgpt.sse.ConsoleEventSourceListener");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
        if (StrUtil.isBlank((CharSequence)completion.getPrompt())) {
            log.error("\u53c2\u6570\u5f02\u5e38\uff1aPrompt\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
        if (!completion.isStream()) {
            completion.setStream(true);
        }
        try {
            EventSource.Factory factory = EventSources.createFactory((OkHttpClient)this.okHttpClient);
            ObjectMapper mapper = new ObjectMapper();
            String requestBody = mapper.writeValueAsString((Object)completion);
            Request request = new Request.Builder().url("https://api.openai.com/v1/completions").post(RequestBody.create((MediaType)MediaType.parse((String)ContentType.JSON.getValue()), (String)requestBody)).header("Authorization", "Bearer " + this.apiKey).build();
            EventSource eventSource = factory.newEventSource(request, eventSourceListener);
        }
        catch (JsonProcessingException e) {
            log.error("\u8bf7\u6c42\u53c2\u6570\u89e3\u6790\u5f02\u5e38\uff1a{}", (Throwable)e);
            e.printStackTrace();
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u53c2\u6570\u89e3\u6790\u5f02\u5e38\uff1a{}", (Throwable)e);
            e.printStackTrace();
        }
    }

    public void streamCompletions(String question, EventSourceListener eventSourceListener) {
        Completion q = Completion.builder().prompt(question).stream(true).build();
        this.streamCompletions(q, eventSourceListener);
    }

    public void streamChatCompletion(ChatCompletion chatCompletion, EventSourceListener eventSourceListener) {
        if (Objects.isNull(eventSourceListener)) {
            log.error("\u53c2\u6570\u5f02\u5e38\uff1aEventSourceListener\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u53ef\u4ee5\u53c2\u8003\uff1acom.unfbx.chatgpt.sse.ConsoleEventSourceListener");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
        if (!chatCompletion.isStream()) {
            chatCompletion.setStream(true);
        }
        try {
            EventSource.Factory factory = EventSources.createFactory((OkHttpClient)this.okHttpClient);
            ObjectMapper mapper = new ObjectMapper();
            String requestBody = mapper.writeValueAsString((Object)chatCompletion);
            Request request = new Request.Builder().url("https://api.openai.com/v1/chat/completions").post(RequestBody.create((MediaType)MediaType.parse((String)ContentType.JSON.getValue()), (String)requestBody)).header("Authorization", "Bearer " + this.apiKey).build();
            EventSource eventSource = factory.newEventSource(request, eventSourceListener);
        }
        catch (JsonProcessingException e) {
            log.error("\u8bf7\u6c42\u53c2\u6570\u89e3\u6790\u5f02\u5e38\uff1a{}", (Throwable)e);
            e.printStackTrace();
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u53c2\u6570\u89e3\u6790\u5f02\u5e38\uff1a{}", (Throwable)e);
            e.printStackTrace();
        }
    }

    public void streamChatCompletion(List<Message> messages, EventSourceListener eventSourceListener) {
        ChatCompletion chatCompletion = ChatCompletion.builder().messages(messages).stream(true).build();
        this.streamChatCompletion(chatCompletion, eventSourceListener);
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public String getApiKey() {
        return this.apiKey;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public static final class Builder {
        @NotNull
        private String apiKey;
        private long connectTimeout;
        private long writeTimeout;
        private long readTimeout;
        private Proxy proxy;

        public Builder apiKey(@NotNull String val) {
            this.apiKey = val;
            return this;
        }

        public Builder connectTimeout(long val) {
            this.connectTimeout = val;
            return this;
        }

        public Builder writeTimeout(long val) {
            this.writeTimeout = val;
            return this;
        }

        public Builder readTimeout(long val) {
            this.readTimeout = val;
            return this;
        }

        public Builder proxy(Proxy val) {
            this.proxy = val;
            return this;
        }

        public OpenAiStreamClient build() {
            return new OpenAiStreamClient(this);
        }
    }
}

