/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt.entity.chat;

import org.jetbrains.annotations.NotNull;

public class Message {
    @NotNull
    private String role;
    @NotNull
    private String content;

    public static Builder builder() {
        return new Builder();
    }

    public Message(String role, String content) {
        this.role = role;
        this.content = content;
    }

    public Message() {
    }

    private Message(Builder builder) {
        this.setRole(builder.role);
        this.setContent(builder.content);
    }

    @NotNull
    public String getRole() {
        return this.role;
    }

    @NotNull
    public String getContent() {
        return this.content;
    }

    public void setRole(@NotNull String role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        this.role = role;
    }

    public void setContent(@NotNull String content) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.content = content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    public String toString() {
        return "Message(role=" + this.getRole() + ", content=" + this.getContent() + ")";
    }

    public static final class Builder {
        @NotNull
        private String role;
        @NotNull
        private String content;

        public Builder role(@NotNull Role role) {
            this.role = role.getName();
            return this;
        }

        public Builder content(@NotNull String content) {
            this.content = content;
            return this;
        }

        public Message build() {
            return new Message(this);
        }
    }

    public static enum Role {
        SYSTEM("system"),
        USER("user"),
        ASSISTANT("assistant");

        private String name;

        public String getName() {
            return this.name;
        }

        private Role(String name) {
            this.name = name;
        }
    }
}

