/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt.entity.completions;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.unfbx.chatgpt.exception.BaseException;
import com.unfbx.chatgpt.exception.CommonError;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Completion
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Completion.class);
    @NonNull
    private String model;
    @NonNull
    private String prompt;
    private String suffix;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    private double temperature;
    @JsonProperty(value="top_p")
    private Integer topP;
    private Integer n;
    private boolean stream;
    private Integer logprobs;
    private boolean echo;
    private List<String> stop;
    @JsonProperty(value="presence_penalty")
    private double presencePenalty;
    @JsonProperty(value="frequency_penalty")
    private double frequencyPenalty;
    @JsonProperty(value="best_of")
    private Integer bestOf;
    @JsonProperty(value="logit_bias")
    private Map logitBias;
    private String user;

    public void setPrompt(String prompt) {
        if (Objects.isNull(prompt) || "".equals(prompt)) {
            log.error("prompt\u53c2\u6570\u5f02\u5e38");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
        this.prompt = prompt;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setMaxTokens(Integer maxTokens) {
        if (maxTokens > 4096) {
            log.error("maxTokens\u53c2\u6570\u5f02\u5e38\uff0c\u4e0d\u80fd\u8d85\u8fc74096");
            this.maxTokens = 4096;
            return;
        }
        if (maxTokens <= 0) {
            log.error("maxTokens\u53c2\u6570\u5f02\u5e38\uff0c\u4e0d\u80fd\u5c0f\u4e8e0");
            this.maxTokens = 64;
            return;
        }
        this.maxTokens = maxTokens;
    }

    public void setTemperature(double temperature) {
        if (temperature > 2.0 || temperature < 0.0) {
            log.error("temperature\u53c2\u6570\u5f02\u5e38\uff0ctemperature\u5c5e\u4e8e[0,2]");
            this.temperature = 2.0;
            return;
        }
        if (temperature < 0.0) {
            log.error("temperature\u53c2\u6570\u5f02\u5e38\uff0ctemperature\u5c5e\u4e8e[0,2]");
            this.temperature = 0.0;
            return;
        }
        this.temperature = temperature;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public void setTopP(Integer topP) {
        this.topP = topP;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public void setLogprobs(Integer logprobs) {
        if (logprobs > 5) {
            log.error("logprobs\u53c2\u6570\u5f02\u5e38\uff0clogprobs\u6700\u5927\u503c==5");
            this.logprobs = 5;
            return;
        }
        this.logprobs = logprobs;
    }

    public void setEcho(boolean echo) {
        this.echo = echo;
    }

    public void setPresencePenalty(double presencePenalty) {
        if (presencePenalty < -2.0) {
            this.presencePenalty = -2.0;
            return;
        }
        if (presencePenalty > 2.0) {
            this.presencePenalty = 2.0;
            return;
        }
        this.presencePenalty = presencePenalty;
    }

    public void setFrequencyPenalty(double frequencyPenalty) {
        if (frequencyPenalty < -2.0) {
            this.frequencyPenalty = -2.0;
            return;
        }
        if (frequencyPenalty > 2.0) {
            this.frequencyPenalty = 2.0;
            return;
        }
        this.frequencyPenalty = frequencyPenalty;
    }

    public void setBestOf(Integer bestOf) {
        this.bestOf = bestOf;
    }

    public void setLogitBias(Map logitBias) {
        this.logitBias = logitBias;
    }

    public void setUser(String user) {
        this.user = user;
    }

    private static String $default$model() {
        return Model.DAVINCI_003.getName();
    }

    private static Integer $default$maxTokens() {
        return 2048;
    }

    private static double $default$temperature() {
        return 0.0;
    }

    private static Integer $default$topP() {
        return 1;
    }

    private static Integer $default$n() {
        return 1;
    }

    private static boolean $default$stream() {
        return false;
    }

    private static boolean $default$echo() {
        return false;
    }

    private static double $default$presencePenalty() {
        return 0.0;
    }

    private static double $default$frequencyPenalty() {
        return 0.0;
    }

    private static Integer $default$bestOf() {
        return 1;
    }

    Completion(@NonNull String model, @NonNull String prompt, String suffix, Integer maxTokens, double temperature, Integer topP, Integer n, boolean stream, Integer logprobs, boolean echo, List<String> stop, double presencePenalty, double frequencyPenalty, Integer bestOf, Map logitBias, String user) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (prompt == null) {
            throw new NullPointerException("prompt is marked non-null but is null");
        }
        this.model = model;
        this.prompt = prompt;
        this.suffix = suffix;
        this.maxTokens = maxTokens;
        this.temperature = temperature;
        this.topP = topP;
        this.n = n;
        this.stream = stream;
        this.logprobs = logprobs;
        this.echo = echo;
        this.stop = stop;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
        this.bestOf = bestOf;
        this.logitBias = logitBias;
        this.user = user;
    }

    public static CompletionBuilder builder() {
        return new CompletionBuilder();
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    @NonNull
    public String getPrompt() {
        return this.prompt;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public Integer getTopP() {
        return this.topP;
    }

    public Integer getN() {
        return this.n;
    }

    public boolean isStream() {
        return this.stream;
    }

    public Integer getLogprobs() {
        return this.logprobs;
    }

    public boolean isEcho() {
        return this.echo;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public double getPresencePenalty() {
        return this.presencePenalty;
    }

    public double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Integer getBestOf() {
        return this.bestOf;
    }

    public Map getLogitBias() {
        return this.logitBias;
    }

    public String getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Completion)) {
            return false;
        }
        Completion other = (Completion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getTemperature(), other.getTemperature()) != 0) {
            return false;
        }
        if (this.isStream() != other.isStream()) {
            return false;
        }
        if (this.isEcho() != other.isEcho()) {
            return false;
        }
        if (Double.compare(this.getPresencePenalty(), other.getPresencePenalty()) != 0) {
            return false;
        }
        if (Double.compare(this.getFrequencyPenalty(), other.getFrequencyPenalty()) != 0) {
            return false;
        }
        Integer this$maxTokens = this.getMaxTokens();
        Integer other$maxTokens = other.getMaxTokens();
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        Integer this$topP = this.getTopP();
        Integer other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Integer this$n = this.getN();
        Integer other$n = other.getN();
        if (this$n == null ? other$n != null : !((Object)this$n).equals(other$n)) {
            return false;
        }
        Integer this$logprobs = this.getLogprobs();
        Integer other$logprobs = other.getLogprobs();
        if (this$logprobs == null ? other$logprobs != null : !((Object)this$logprobs).equals(other$logprobs)) {
            return false;
        }
        Integer this$bestOf = this.getBestOf();
        Integer other$bestOf = other.getBestOf();
        if (this$bestOf == null ? other$bestOf != null : !((Object)this$bestOf).equals(other$bestOf)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$prompt = this.getPrompt();
        String other$prompt = other.getPrompt();
        if (this$prompt == null ? other$prompt != null : !this$prompt.equals(other$prompt)) {
            return false;
        }
        String this$suffix = this.getSuffix();
        String other$suffix = other.getSuffix();
        if (this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix)) {
            return false;
        }
        List<String> this$stop = this.getStop();
        List<String> other$stop = other.getStop();
        if (this$stop == null ? other$stop != null : !((Object)this$stop).equals(other$stop)) {
            return false;
        }
        Map this$logitBias = this.getLogitBias();
        Map other$logitBias = other.getLogitBias();
        if (this$logitBias == null ? other$logitBias != null : !((Object)this$logitBias).equals(other$logitBias)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        return !(this$user == null ? other$user != null : !this$user.equals(other$user));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Completion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $temperature = Double.doubleToLongBits(this.getTemperature());
        result = result * 59 + (int)($temperature >>> 32 ^ $temperature);
        result = result * 59 + (this.isStream() ? 79 : 97);
        result = result * 59 + (this.isEcho() ? 79 : 97);
        long $presencePenalty = Double.doubleToLongBits(this.getPresencePenalty());
        result = result * 59 + (int)($presencePenalty >>> 32 ^ $presencePenalty);
        long $frequencyPenalty = Double.doubleToLongBits(this.getFrequencyPenalty());
        result = result * 59 + (int)($frequencyPenalty >>> 32 ^ $frequencyPenalty);
        Integer $maxTokens = this.getMaxTokens();
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        Integer $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Integer $n = this.getN();
        result = result * 59 + ($n == null ? 43 : ((Object)$n).hashCode());
        Integer $logprobs = this.getLogprobs();
        result = result * 59 + ($logprobs == null ? 43 : ((Object)$logprobs).hashCode());
        Integer $bestOf = this.getBestOf();
        result = result * 59 + ($bestOf == null ? 43 : ((Object)$bestOf).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : $prompt.hashCode());
        String $suffix = this.getSuffix();
        result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
        List<String> $stop = this.getStop();
        result = result * 59 + ($stop == null ? 43 : ((Object)$stop).hashCode());
        Map $logitBias = this.getLogitBias();
        result = result * 59 + ($logitBias == null ? 43 : ((Object)$logitBias).hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        return result;
    }

    public String toString() {
        return "Completion(model=" + this.getModel() + ", prompt=" + this.getPrompt() + ", suffix=" + this.getSuffix() + ", maxTokens=" + this.getMaxTokens() + ", temperature=" + this.getTemperature() + ", topP=" + this.getTopP() + ", n=" + this.getN() + ", stream=" + this.isStream() + ", logprobs=" + this.getLogprobs() + ", echo=" + this.isEcho() + ", stop=" + this.getStop() + ", presencePenalty=" + this.getPresencePenalty() + ", frequencyPenalty=" + this.getFrequencyPenalty() + ", bestOf=" + this.getBestOf() + ", logitBias=" + this.getLogitBias() + ", user=" + this.getUser() + ")";
    }

    public static class CompletionBuilder {
        private boolean model$set;
        private String model$value;
        private String prompt;
        private String suffix;
        private boolean maxTokens$set;
        private Integer maxTokens$value;
        private boolean temperature$set;
        private double temperature$value;
        private boolean topP$set;
        private Integer topP$value;
        private boolean n$set;
        private Integer n$value;
        private boolean stream$set;
        private boolean stream$value;
        private Integer logprobs;
        private boolean echo$set;
        private boolean echo$value;
        private List<String> stop;
        private boolean presencePenalty$set;
        private double presencePenalty$value;
        private boolean frequencyPenalty$set;
        private double frequencyPenalty$value;
        private boolean bestOf$set;
        private Integer bestOf$value;
        private Map logitBias;
        private String user;

        CompletionBuilder() {
        }

        public CompletionBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model$value = model;
            this.model$set = true;
            return this;
        }

        public CompletionBuilder prompt(@NonNull String prompt) {
            if (prompt == null) {
                throw new NullPointerException("prompt is marked non-null but is null");
            }
            this.prompt = prompt;
            return this;
        }

        public CompletionBuilder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        @JsonProperty(value="max_tokens")
        public CompletionBuilder maxTokens(Integer maxTokens) {
            this.maxTokens$value = maxTokens;
            this.maxTokens$set = true;
            return this;
        }

        public CompletionBuilder temperature(double temperature) {
            this.temperature$value = temperature;
            this.temperature$set = true;
            return this;
        }

        @JsonProperty(value="top_p")
        public CompletionBuilder topP(Integer topP) {
            this.topP$value = topP;
            this.topP$set = true;
            return this;
        }

        public CompletionBuilder n(Integer n) {
            this.n$value = n;
            this.n$set = true;
            return this;
        }

        public CompletionBuilder stream(boolean stream) {
            this.stream$value = stream;
            this.stream$set = true;
            return this;
        }

        public CompletionBuilder logprobs(Integer logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        public CompletionBuilder echo(boolean echo) {
            this.echo$value = echo;
            this.echo$set = true;
            return this;
        }

        public CompletionBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        @JsonProperty(value="presence_penalty")
        public CompletionBuilder presencePenalty(double presencePenalty) {
            this.presencePenalty$value = presencePenalty;
            this.presencePenalty$set = true;
            return this;
        }

        @JsonProperty(value="frequency_penalty")
        public CompletionBuilder frequencyPenalty(double frequencyPenalty) {
            this.frequencyPenalty$value = frequencyPenalty;
            this.frequencyPenalty$set = true;
            return this;
        }

        @JsonProperty(value="best_of")
        public CompletionBuilder bestOf(Integer bestOf) {
            this.bestOf$value = bestOf;
            this.bestOf$set = true;
            return this;
        }

        @JsonProperty(value="logit_bias")
        public CompletionBuilder logitBias(Map logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public CompletionBuilder user(String user) {
            this.user = user;
            return this;
        }

        public Completion build() {
            String model$value = this.model$value;
            if (!this.model$set) {
                model$value = Completion.$default$model();
            }
            Integer maxTokens$value = this.maxTokens$value;
            if (!this.maxTokens$set) {
                maxTokens$value = Completion.$default$maxTokens();
            }
            double temperature$value = this.temperature$value;
            if (!this.temperature$set) {
                temperature$value = Completion.$default$temperature();
            }
            Integer topP$value = this.topP$value;
            if (!this.topP$set) {
                topP$value = Completion.$default$topP();
            }
            Integer n$value = this.n$value;
            if (!this.n$set) {
                n$value = Completion.$default$n();
            }
            boolean stream$value = this.stream$value;
            if (!this.stream$set) {
                stream$value = Completion.$default$stream();
            }
            boolean echo$value = this.echo$value;
            if (!this.echo$set) {
                echo$value = Completion.$default$echo();
            }
            double presencePenalty$value = this.presencePenalty$value;
            if (!this.presencePenalty$set) {
                presencePenalty$value = Completion.$default$presencePenalty();
            }
            double frequencyPenalty$value = this.frequencyPenalty$value;
            if (!this.frequencyPenalty$set) {
                frequencyPenalty$value = Completion.$default$frequencyPenalty();
            }
            Integer bestOf$value = this.bestOf$value;
            if (!this.bestOf$set) {
                bestOf$value = Completion.$default$bestOf();
            }
            return new Completion(model$value, this.prompt, this.suffix, maxTokens$value, temperature$value, topP$value, n$value, stream$value, this.logprobs, echo$value, this.stop, presencePenalty$value, frequencyPenalty$value, bestOf$value, this.logitBias, this.user);
        }

        public String toString() {
            return "Completion.CompletionBuilder(model$value=" + this.model$value + ", prompt=" + this.prompt + ", suffix=" + this.suffix + ", maxTokens$value=" + this.maxTokens$value + ", temperature$value=" + this.temperature$value + ", topP$value=" + this.topP$value + ", n$value=" + this.n$value + ", stream$value=" + this.stream$value + ", logprobs=" + this.logprobs + ", echo$value=" + this.echo$value + ", stop=" + this.stop + ", presencePenalty$value=" + this.presencePenalty$value + ", frequencyPenalty$value=" + this.frequencyPenalty$value + ", bestOf$value=" + this.bestOf$value + ", logitBias=" + this.logitBias + ", user=" + this.user + ")";
        }
    }

    public static enum Model {
        DAVINCI_003("text-davinci-003"),
        DAVINCI_002("text-davinci-002"),
        DAVINCI("davinci");

        private String name;

        public String getName() {
            return this.name;
        }

        private Model(String name) {
            this.name = name;
        }
    }
}

