/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.registry.impl;

import com.xxl.rpc.registry.ServiceRegistry;
import com.xxl.rpc.util.XxlRpcException;
import com.xxl.rpc.util.XxlZkClient;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkServiceRegistry
extends ServiceRegistry {
    private static Logger logger = LoggerFactory.getLogger(ZkServiceRegistry.class);
    private static final String zkBasePath = "/xxl-rpc";
    private String zkEnvPath;
    private XxlZkClient xxlZkClient = null;
    private Thread refreshThread;
    private boolean refreshThreadStop = false;
    private volatile ConcurrentMap<String, TreeSet<String>> registryData = new ConcurrentHashMap<String, TreeSet<String>>();
    private volatile ConcurrentMap<String, TreeSet<String>> discoveryData = new ConcurrentHashMap<String, TreeSet<String>>();

    public String keyToPath(String nodeKey) {
        return this.zkEnvPath + "/" + nodeKey;
    }

    public String pathToKey(String nodePath) {
        if (nodePath == null || nodePath.length() <= this.zkEnvPath.length() || !nodePath.startsWith(this.zkEnvPath)) {
            return null;
        }
        return nodePath.substring(this.zkEnvPath.length() + 1, nodePath.length());
    }

    @Override
    public void start(Map<String, String> param) {
        String zkaddress = param.get("zkaddress");
        String zkdigest = param.get("zkdigest");
        String env = param.get("env");
        if (zkaddress == null || zkaddress.trim().length() == 0) {
            throw new XxlRpcException("xxl-rpc zkaddress can not be empty");
        }
        if (env == null || env.trim().length() == 0) {
            throw new XxlRpcException("xxl-rpc env can not be empty");
        }
        this.zkEnvPath = zkBasePath.concat("/").concat(env);
        this.xxlZkClient = new XxlZkClient(zkaddress, this.zkEnvPath, zkdigest, new Watcher(){

            public void process(WatchedEvent watchedEvent) {
                try {
                    String path;
                    String key;
                    logger.debug(">>>>>>>>>> xxl-rpc: watcher:{}", (Object)watchedEvent);
                    if (watchedEvent.getState() == Watcher.Event.KeeperState.Expired) {
                        ZkServiceRegistry.this.xxlZkClient.destroy();
                        ZkServiceRegistry.this.xxlZkClient.getClient();
                        ZkServiceRegistry.this.refreshDiscoveryData(null);
                        logger.info(">>>>>>>>>> xxl-rpc, zk re-connect reloadAll success.");
                    }
                    if ((key = ZkServiceRegistry.this.pathToKey(path = watchedEvent.getPath())) != null) {
                        ZkServiceRegistry.this.xxlZkClient.getClient().exists(path, true);
                        if (watchedEvent.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
                            ZkServiceRegistry.this.refreshDiscoveryData(key);
                        } else if (watchedEvent.getState() == Watcher.Event.KeeperState.SyncConnected) {
                            logger.info("reload all 111");
                        }
                    }
                }
                catch (KeeperException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        });
        this.xxlZkClient.getClient();
        this.refreshThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!ZkServiceRegistry.this.refreshThreadStop) {
                    try {
                        TimeUnit.SECONDS.sleep(60L);
                        ZkServiceRegistry.this.refreshDiscoveryData(null);
                        ZkServiceRegistry.this.refreshRegistryData();
                    }
                    catch (Exception e) {
                        if (ZkServiceRegistry.this.refreshThreadStop) continue;
                        logger.error(">>>>>>>>>> xxl-rpc, refresh thread error.", (Throwable)e);
                    }
                }
                logger.info(">>>>>>>>>> xxl-rpc, refresh thread stoped.");
            }
        });
        this.refreshThread.setName("xxl-rpc, ZkServiceRegistry refresh thread.");
        this.refreshThread.setDaemon(true);
        this.refreshThread.start();
        logger.info(">>>>>>>>>> xxl-rpc, ZkServiceRegistry init success. [env={}]", (Object)env);
    }

    @Override
    public void stop() {
        if (this.xxlZkClient != null) {
            this.xxlZkClient.destroy();
        }
        if (this.refreshThread != null) {
            this.refreshThreadStop = true;
            this.refreshThread.interrupt();
        }
    }

    private void refreshDiscoveryData(String key) {
        HashSet<String> keys = new HashSet<String>();
        if (key != null && key.trim().length() > 0) {
            keys.add(key);
        } else if (this.discoveryData.size() > 0) {
            keys.addAll(this.discoveryData.keySet());
        }
        if (keys.size() > 0) {
            for (String keyItem : keys) {
                String path = this.keyToPath(keyItem);
                Map<String, String> childPathData = this.xxlZkClient.getChildPathData(path);
                TreeSet<String> existValues = (TreeSet<String>)this.discoveryData.get(keyItem);
                if (existValues == null) {
                    existValues = new TreeSet<String>();
                    this.discoveryData.put(keyItem, existValues);
                }
                if (childPathData.size() <= 0) continue;
                existValues.addAll(childPathData.keySet());
            }
            logger.info(">>>>>>>>>> xxl-rpc, refresh discovery data success, discoveryData = {}", this.discoveryData);
        }
    }

    private void refreshRegistryData() {
        if (this.registryData.size() > 0) {
            for (Map.Entry item : this.registryData.entrySet()) {
                String key = (String)item.getKey();
                for (String value : (TreeSet)item.getValue()) {
                    String path = this.keyToPath(key);
                    this.xxlZkClient.setChildPathData(path, value, "");
                }
            }
            logger.info(">>>>>>>>>> xxl-rpc, refresh registry data success, registryData = {}", this.registryData);
        }
    }

    @Override
    public boolean registry(String key, String value) {
        TreeSet<String> values = (TreeSet<String>)this.registryData.get(key);
        if (values == null) {
            values = new TreeSet<String>();
            this.registryData.put(key, values);
        }
        values.add(value);
        String path = this.keyToPath(key);
        this.xxlZkClient.setChildPathData(path, value, "");
        logger.info(">>>>>>>>>> xxl-rpc, registry success, key = {}, value = {}", (Object)key, (Object)value);
        return true;
    }

    @Override
    public boolean remove(String key, String value) {
        TreeSet values = (TreeSet)this.discoveryData.get(key);
        if (values != null) {
            values.remove(value);
        }
        String path = this.keyToPath(key);
        this.xxlZkClient.deleteChildPath(path, value);
        return true;
    }

    @Override
    public TreeSet<String> discovery(String key) {
        TreeSet values = (TreeSet)this.discoveryData.get(key);
        if (values == null) {
            this.refreshDiscoveryData(key);
            values = (TreeSet)this.discoveryData.get(key);
        }
        return values;
    }
}

