/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.extension.multiplex;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.extension.multiplex.MultiplexOptions;
import org.smartboot.socket.extension.plugins.IdleStatePlugin;
import org.smartboot.socket.extension.plugins.Plugin;
import org.smartboot.socket.extension.plugins.SslPlugin;
import org.smartboot.socket.extension.processor.AbstractMessageProcessor;
import org.smartboot.socket.extension.ssl.factory.ClientSSLContextFactory;
import org.smartboot.socket.timer.HashedWheelTimer;
import org.smartboot.socket.timer.TimerTask;
import org.smartboot.socket.transport.AioQuickClient;
import org.smartboot.socket.transport.AioSession;

public class MultiplexClient<T> {
    protected final MultiplexOptions<T> multiplexOptions = new MultiplexOptions();
    private final AbstractMessageProcessor<T> processor;
    private final Protocol<T> protocol;
    private boolean closed;
    private boolean firstConnected = true;
    private final ConcurrentLinkedDeque<AioQuickClient> resuingClients = new ConcurrentLinkedDeque();
    private final ConcurrentHashMap<AioQuickClient, AioQuickClient> clients = new ConcurrentHashMap();
    private volatile TimerTask timerTask;
    private long latestTime = System.currentTimeMillis();
    private volatile Semaphore semaphore;

    public MultiplexClient(AbstractMessageProcessor<T> processor, Protocol<T> protocol) {
        this.processor = processor;
        this.protocol = protocol;
    }

    public MultiplexOptions<T> getMultiplexOptions() {
        return this.multiplexOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AioQuickClient acquire() throws Throwable {
        AioQuickClient client;
        if (this.closed) {
            throw new IllegalStateException("client closed");
        }
        this.latestTime = System.currentTimeMillis();
        if (this.semaphore == null) {
            MultiplexClient multiplexClient = this;
            synchronized (multiplexClient) {
                if (this.semaphore == null) {
                    this.semaphore = new Semaphore(this.multiplexOptions.getMaxConnections());
                }
            }
        }
        this.semaphore.acquire();
        while ((client = this.resuingClients.pollFirst()) != null) {
            AioSession session = client.getSession();
            if (session == null || session.isInvalid()) {
                this.release(client);
                continue;
            }
            this.onReuse(client);
            return client;
        }
        this.createNewClient();
        return this.acquire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewClient() throws Exception {
        if (this.firstConnected) {
            MultiplexClient multiplexClient = this;
            synchronized (multiplexClient) {
                if (this.firstConnected) {
                    boolean noneSslPlugin = true;
                    for (Plugin<T> responsePlugin : this.multiplexOptions.getPlugins()) {
                        if (!(responsePlugin instanceof SslPlugin)) continue;
                        noneSslPlugin = false;
                        break;
                    }
                    if (noneSslPlugin && this.multiplexOptions.isSsl()) {
                        this.processor.addPlugin(new SslPlugin(new ClientSSLContextFactory()));
                    }
                    if (this.multiplexOptions.idleTimeout() > 0) {
                        this.processor.addPlugin(new IdleStatePlugin(this.multiplexOptions.idleTimeout()));
                    }
                    for (Plugin<T> responsePlugin : this.multiplexOptions.getPlugins()) {
                        this.processor.addPlugin(responsePlugin);
                    }
                    this.firstConnected = false;
                }
            }
        }
        AioQuickClient client = new AioQuickClient(this.multiplexOptions.getHost(), this.multiplexOptions.getPort(), this.protocol, this.processor);
        client.setReadBufferSize(this.multiplexOptions.getReadBufferSize()).setWriteBuffer(this.multiplexOptions.getWriteChunkSize(), this.multiplexOptions.getWriteChunkCount());
        client.setBufferPagePool(this.multiplexOptions.getReadBufferPool(), this.multiplexOptions.getWriteBufferPool());
        if (this.multiplexOptions.getConnectTimeout() > 0) {
            client.connectTimeout(this.multiplexOptions.getConnectTimeout());
        }
        if (this.multiplexOptions.group() == null) {
            client.start();
        } else {
            client.start(this.multiplexOptions.group());
        }
        this.clients.put(client, client);
        this.resuingClients.offerLast(client);
        this.startConnectionMonitor();
        this.onNew(client);
    }

    protected void onNew(AioQuickClient client) {
    }

    protected void onReuse(AioQuickClient client) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startConnectionMonitor() {
        if (this.timerTask != null) {
            return;
        }
        MultiplexClient multiplexClient = this;
        synchronized (multiplexClient) {
            if (this.timerTask != null) {
                return;
            }
            this.timerTask = HashedWheelTimer.DEFAULT_TIMER.scheduleWithFixedDelay(() -> {
                long time = this.latestTime;
                if (System.currentTimeMillis() - time > 60000L) {
                    AioQuickClient c;
                    while (time == this.latestTime && this.clients.size() > this.multiplexOptions.getMinConnections() && (c = this.resuingClients.poll()) != null) {
                        this.release(c);
                    }
                }
                if (this.clients.isEmpty()) {
                    TimerTask oldTask = this.timerTask;
                    this.timerTask = null;
                    oldTask.cancel();
                    if (!this.clients.isEmpty()) {
                        this.startConnectionMonitor();
                    }
                }
                this.maintainMinConnections();
            }, 1L, TimeUnit.MINUTES);
            this.maintainMinConnections();
        }
    }

    private void maintainMinConnections() {
        while (this.clients.size() < this.multiplexOptions.getMinConnections()) {
            try {
                this.createNewClient();
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
    }

    public final void reuse(AioQuickClient client) {
        this.resuingClients.addFirst(client);
        this.releaseSemaphore();
    }

    public final void release(AioQuickClient client) {
        if (this.clients.remove(client) == null) {
            throw new IllegalArgumentException("client is not belong to this multiplex client");
        }
        try {
            client.shutdownNow();
        }
        finally {
            this.releaseSemaphore();
        }
    }

    private void releaseSemaphore() {
        this.semaphore.release();
    }

    public void close() {
        this.closed = true;
        this.clients.forEach((client, aioQuickClient) -> this.release((AioQuickClient)client));
    }
}

